'******************************************************************************
' HTTP routines
'******************************************************************************
' six1 01/2010
' based on Michael's Code http://bascom-forum.de/index
' Vielen Dank fr deine erste Version!
'******************************************************************************

'  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'   Lizenz(beiliegend Lizenz.pdf) Http : / / Creativecommons.org / Licenses / By -nc -sa / 3.0 / De/
'
'
'   Es Ist Ihnen Gestattet:
'
'     * Das Werk Vervielfltigen , Verbreiten Und ffentlich Zugnglich Machen
'
'     * Abwandlungen Bzw. Bearbeitungen Des Inhaltes Anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung. Sie Mssen Den Namen Des Autors / Rechteinhabers In Der Von Ihm Festgelegten Weise Nennen.
'
'     * Keine Kommerzielle Nutzung. Dieses Werk Darf Nicht Fr Kommerzielle Zwecke Verwendet Werden.
'
'     * Weitergabe Unter Gleichen Bedingungen. Wenn Sie Den Lizenzierten Inhalt Bearbeiten Oder In Anderer Weise
'      Umgestalten , Verndern Oder Als Grundlage Fr Einen Anderen Inhalt Verwenden ,
'      Drfen Sie Den Neu Entstandenen Inhalt Nur Unter Verwendung Von Lizenzbedingungen Weitergeben ,
'      Die Mit Denen Dieses Lizenzvertrages Identisch Oder Vergleichbar Sind.
'
'     * Im Falle Einer Verbreitung Mssen Sie Anderen Die Lizenzbedingungen , Unter Welche Dieses Werk Fllt ,
'      Mitteilen. Am Einfachsten Ist Es , Einen Link Auf Diese Seite Einzubinden.
'     * Any Of The Above Conditions Can Be Waived If You Get Permission From The Copyright Holder.
'     * Das Urheberpersnlichkeitsrecht Des Rechteinhabers;
'
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

'-------------------------------------------------------------------------------
' BESCHREIBUNG TCP FLAGs
'-------------------------------------------------------------------------------
'(
Tcp -flag Beschreibung
Urgent -pointer -flag
(urg -flag) Ist Das Urg -flag Gesetzt Wird Das Urgent -pointer -feld Ausgewertet.
            Ein Solches Datenpaket Ist Keiner Anwendung Zugeordnet. Es Hat Eine Besondere Prioritt.
Acknowledgement -flag
(ack -flag) Da Sich Die Acknowledgement -nummer Nicht Bei Jedem Datenpaket ndert,
            Kennzeichnet Ein Gesetztes Ack -flag Die Gltigkeit Der Acknowledgement -nummer.
Push -flag
(psh -flag) Tcp Puffert Einzelne Datenpakete Bis Eine Grere Zusammenhngende
            Datenmenge Vorhanden Ist. Ist Das Psh -flag Gesetzt , Wird Dieses Paket
            Sofort An Den Tcp -port Weitergeleitet.
Reset -flag
(rst -flag) Ist Ein Abbruch Der Tcp -verbindung Notwendig , Wird Das Rst -flag Gesetzt.
            Es Kommt Auch Zum Einsatz , Wenn Eine Tcp -verbindung Abgewiesen Wird.
Syncronization -flag
(syn -flag) Das Syn -flag Wird Gesetzt , Wenn Zwischen Sender Und Empfnger Eine
            Verbindung Aufgebaut Werden Soll.
Final -flag
(fin -flag) Sind Zwischen Zwei Stationen Alle Daten bertragen , Senden Beide Stationen
            Ein Tcp -paket Mit Gesetztem Fin -flag. Danach Gilt Die Tcp -verbindung Als Beendet.
')
'-------------------------------------------------------------------------------
$nocompile

'-------------------------------------------------------------------------------
' HTTP Ablaufsteuerung
'   nach ankommenden Flags in TCP werden die Funktionen aufgerufen
'-------------------------------------------------------------------------------
Sub Http
   #if Debug_http > 3
     Call Http_debug_flags
   #endif
   If Tcp_syn = 1 Then
       Call Http_syncronisation
   Else
       If Tcp_ack = 1 Then
          If Tcp_psh = 1 Then
            'Anfrage /GET
            Call Http_anfrage
          Else                                              'Tcp_psh = 1
            If Tcp_fin = 1 Then                             'ACK=1 SYN=0 PSH=0
               'ACK auf FIN senden
               Call Ack_auf_fin_senden
            Else
               ' ACK auf gesendetes Segment
               Call Http_process_fifo_entry
            End If                                          'Tcp_fin = 1 ACK=1 SYN=0 PSH=0
          End If                                            'Tcp_psh = 1 ACK=1 SYN=0
       Else                                                 'Tcp_ack = 1
          If Tcp_fin = 1 Then
            'kommt eigentlich nicht vor, aber trotzdem behandeln
          End If                                            'Tcp_fin = 1
       End If                                               'Tcp_ack = 1
   End If                                                   'Tcp_syn = 1
End Sub


'-------------------------------------------------------------------------------
' HTTP Syncronisation
'    erster Aufruf; SYN-ACK auf SYN-ANFRAGE
'-------------------------------------------------------------------------------
Sub Http_syncronisation
   Local Lb As Byte
   Local Lbl As Byte
   Local Lbh As Byte
   Local Lw As Word
   Local Ll As Long

   Tcp_flags = 0
   Set Tcp_ack
   'grundstzlich den Verbindungswunsch abweisen!
   Set Tcp_rst

   Call Tcp_swap_seq_ack(tcp_seqnum , Tcp_acknum , 1)

   For Lb = 1 To Http_max_ports
        If Http_stack_port_dest(lb) = 0 Then
            Http_stack_mac0(lb) = Eth_b_src_mac(1)
            Http_stack_mac1(lb) = Eth_b_src_mac(2)
            Http_stack_mac2(lb) = Eth_b_src_mac(3)
            Http_stack_mac3(lb) = Eth_b_src_mac(4)
            Http_stack_mac4(lb) = Eth_b_src_mac(5)
            Http_stack_mac5(lb) = Eth_b_src_mac(6)
            Http_stack_headerlength(lb) = 0
            Http_stack_fragment(lb) = Ip_w_fragmentation
            Http_stack_lifetime(lb) = Http_lifetime_seconds
            Http_stack_ipsrc(lb) = T_ip_srcaddr
            Http_stack_ipdest(lb) = T_ip_destaddr
            Http_stack_port_src(lb) = Tcp_srcport
            Http_stack_port_dest(lb) = Tcp_destport
            Http_stack_seqnum(lb) = Tcp_seqnum
            Http_stack_acknum(lb) = 0                       'Tcp_acknum
            Http_stack_retry(lb) = 0
            Set Tcp_syn
            ' wenn ein Platz im http-stack vorhanden, Vebindung NICHT abweisen!
            Reset Tcp_rst
            #if Debug_http > 1
              Print "<-- SYN-ACK  " ; Ip_to_string(t_ip_srcaddr)
            #endif
            Exit For
        End If
    Next

    Tcp_win_size = Maxload
    Call Tcp_swap_ip
    Call Tcp_swap_mac
    Call Tcp_swap_port
    Call Set_ip_header_len(&H3e)
    Tcp_hdr = &H70                                          'TCP Header Lnge 7*4=28
    Call Ip_header_checksum
    Call Tcp_checksum
    Call Enc28j60packetsend(62)                             'raus mit
End Sub

'-------------------------------------------------------------------------------
' Proccess_fifo_stack_entry
'   Anfrage auf Port auf http-Stack in Fifo eintragen
'-------------------------------------------------------------------------------
Function Proccess_fifo_stack_entry(byref Http_stack_position As Byte) As Byte
Local Tmp_b As Byte
         Proccess_fifo_stack_entry = 0
         For Tmp_b = 1 To Http_max_ports
            If Fifo(tmp_b) = 0 Then
                 Fifo(tmp_b) = Http_stack_position
                 Proccess_fifo_stack_entry = Tmp_b
                 Http_stack_flag = 1
                 Exit For
            End If
         Next
End Function


'-------------------------------------------------------------------------------
' Http_process_fifo_entry
'   INCOMING ACK
'-------------------------------------------------------------------------------
Sub Http_process_fifo_entry
 Local Http_stack_position As Byte , Pos As Byte
 Local L_l As Long

  Http_stack_position = Http_find_stack_position(tcp_srcport)
  If Http_stack_position = 0 Then
    #if Debug_http > 1
      Print "...in Http_process_fifo_entry"
    #endif
  Else
    If Http_stack_fin(http_stack_position) = 0 Then
        #if Debug_http > 1
           Print "--> ACK '" ; Http_stack_filename(http_stack_position) ; "' (" ; Reversed_long(tcp_acknum) ; ")"
        #endif
         If Len(http_stack_filename(http_stack_position)) > 2 Then
            Http_stack_acknum(http_stack_position) = Tcp_acknum
            Pos = Proccess_fifo_stack_entry(http_stack_position)
            Http_stack_lifetime(http_stack_position) = Http_lifetime_seconds
            Http_stack_retry(http_stack_position) = 0
         Else
           #if Debug_http > 0
              Print "--> ACK connection established " ; ; Ip_to_string(t_ip_srcaddr) ; " Port " ; Reversed_word(tcp_srcport)
           #endif
         End If
    Elseif Http_stack_fin(http_stack_position) = 1 Then
        #if Debug_http > 0
        Print "FIN=1 waiting on FIN/ACK! " ; Ip_to_string(t_ip_srcaddr) ; " Port " ; Reversed_word(tcp_srcport)
        #endif
    Elseif Http_stack_fin(http_stack_position) = 2 Then
          ' ACK auf ein vorangegangenes FIN-ACK
          Call Reset_stack_entry(http_stack_position )
    End If
  End If
End Sub


'-------------------------------------------------------------------------------
' Reset_stack_entry(Nr)
'   Eintrag im http-Stack lschen
'-------------------------------------------------------------------------------
Sub Reset_stack_entry(byval Nr As Byte)
Local Lb As Byte
    If Nr > 0 Then
        #if Debug_http > 2
           Call Http_dump_stack( "***  RESET STACK ENTRY ***" , Nr)
        #endif
        Http_stack_port_src(nr) = 0
        Http_stack_port_dest(nr) = 0
        Http_stack_filename(nr) = ""
        Http_stack_ipdest(nr) = 0
        Http_stack_ipsrc(nr) = 0
        Http_stack_acknum(nr) = 0
        Http_stack_seqnum(nr) = 0
        Http_stack_fin(nr) = 0
        Http_stack_lifetime(nr) = 0
        Http_stack_retry(nr) = 0
        For Lb = 1 To Http_max_ports
            If Fifo(lb) = Nr Then
                Fifo(lb) = 0
            End If
        Next
       ' Call Rotate_fifo
     End If
End Sub



'-------------------------------------------------------------------------------
' Ack_auf_fin_senden
'   Gegenstelle akzeptiert das FIN-ACK eines Segment! --> besttigen
'-------------------------------------------------------------------------------
Sub Ack_auf_fin_senden
 Local Http_stack_position As Byte

    Http_stack_position = Http_find_stack_position(tcp_srcport)

    If Http_stack_position > 0 Then

      #if Debug_http > 1
        Print "--> ACK FIN " ; Http_stack_filename(http_stack_position)
      #endif

      Call Tcp_swap_seq_ack(tcp_seqnum , Tcp_acknum , 1)
      Call Tcp_swap_ip
      Call Tcp_swap_mac
      Call Tcp_swap_port
      Tcp_flags = 0
      Set Tcp_ack

      Call Set_ip_header_len(&H3e)
      Tcp_hdr = &H70
      Call Ip_header_checksum
      Call Tcp_checksum
      Call Enc28j60packetsend(62)
      Call Reset_stack_entry(http_stack_position)
    Else
      #if Debug_http > 1
       Print "...in Ack auf FIN"
      #endif
    End If
End Sub



'-------------------------------------------------------------------------------
' Http_find_stack_position
'   sucht den Stack Eintrag zur bergebenen SourcePortnummer
'-------------------------------------------------------------------------------
Function Http_find_stack_position(byval Tcp_port As Word) As Byte
Local Tempx As Byte
     Http_find_stack_position = 0
     For Tempx = 1 To Http_max_ports
         If Http_stack_port_src(tempx) = Tcp_port Then
              Http_find_stack_position = Tempx
              Exit For
         End If
         #if Debug_http > 1
             If Http_find_stack_position > 0 Then
                 If Http_stack_filename(http_find_stack_position) <> "" Then
                    ' Anfrager wird ungeduldig! Erneute Anfrage nach File!
                    Print "--> ACK PSH (TCP RETRANSMISSION)! " ; Http_stack_filename(http_find_stack_position)
                 End If
             End If
         #endif

     Next
     #if Debug_http > 1
     If Http_find_stack_position = 0 Then
        Print " Stack position not found! Searching for Port: " ; Reversed_word(tcp_port)
     End If
     #endif
End Function

'-------------------------------------------------------------------------------
' Http_anfrage
'   Anfrage nach File. In Stack aufnehmen!
'-------------------------------------------------------------------------------
Sub Http_anfrage
  Local Pos As Byte
  Local L_l As Long
  Local Http_get_filename As String * 15
  Local Content_typ As Byte
  Local Http_stack_position As Byte
  Local Temp_w As Word
#if Netio_mode = 1
  Local S_s As String * 8
  Local Flag As Byte
#endif

' G=71
' E=69
' T=84
'" "=32
' /=47
'schneller, als erst einen String zusammen zu basteln!
     If Buffer(55) = 71 And Buffer(56) = 69 And Buffer(57) = 84 And Buffer(58) = 32 And Buffer(59) = 47 Then


          If Buffer(60) = 32 Then
              Http_get_filename = "index.htm"
          Else
             Http_get_filename = ""
#if Netio_mode = 1
             S_s = ""
             Flag = 0
#endif
             For Pos = 60 To 79
#if Netio_mode = 1
               If Buffer(pos) = 63 Then
                 Flag = 1
               End If
#endif
               If Buffer(pos) = 32 Then
                 Exit For
               End If
#if Netio_mode = 1
               If Flag = 0 Then
#endif
                  Http_get_filename = Http_get_filename + Chr(buffer(pos))
#if Netio_mode = 1
               Else
                  S_s = S_s + Chr(buffer(pos))
               End If
#endif
             Next
          End If
      End If
#if Netio_mode = 1
      If S_s <> "" Then
         Switch_port = Mid(s_s , 4 , 1)
         Switch_value = Mid(s_s , 5 , 1)
         Pos = Val(switch_port)
         If Switch_value = "0" Then
           Reset Portc.pos
         Else
           Set Portc.pos
         End If
      End If
#endif


    '  Http_get_filename = Lcase(http_get_filename)
    '  Http_get_filename = Trim(http_get_filename)
      ' ACHTUNG! bei SD-CARD Betrieb 8.3 Filenamen!
      If Right(http_get_filename , 3) = "htm" Then
            Content_typ = 1
            If Http_get_filename = "index.htm" Then
               Incr Http_z_index
            End If
      Elseif Right(http_get_filename , 3) = "jpg" Then
            Content_typ = 2
      Elseif Right(http_get_filename , 3) = "ico" Then
            Content_typ = 3
      Elseif Right(http_get_filename , 2) = "js" Then
            Content_typ = 4
      Elseif Right(http_get_filename , 3) = "gif" Then
            Content_typ = 5
      Elseif Right(http_get_filename , 3) = "png" Then
            Content_typ = 6
      Elseif Right(http_get_filename , 3) = "css" Then
            Content_typ = 7
#if Include_svg = 1
      'Dynamische, graphische Inhalte (werden im Programmablauf unter "FUNCTION SVG" erstellt)
      Elseif Right(http_get_filename , 3) = "svg" Then
            Content_typ = 10
#endif
#if Include_ajax = 1
      'Dynamische AJAX Inhalte
      Elseif Instr(http_get_filename , "ax2") > 0 Then
               Content_typ = 8
               Pos = Len(http_get_filename)
               Decr Pos
               Http_get_filename = Left(http_get_filename , Pos)
#endif
      'statische AJAX Inhalte, liegen auf SD-Card!
      Elseif Instr(http_get_filename , "ax1") > 0 Then
               Content_typ = 9
               Pos = Len(http_get_filename)
               Decr Pos
               Http_get_filename = Left(http_get_filename , Pos)
      Else
#if Netio_mode = 1
            If Commandmodem32 = 0 Then
#endif
              Content_typ = 0
              Print " File not found: " ; Http_get_filename
#if Netio_mode = 1
            End If
#endif
      End If


      Http_stack_position = Http_find_stack_position(tcp_srcport)
      If Content_typ <> 0 Then
         If Http_stack_position > 0 Then
             Http_stack_filename(http_stack_position) = Http_get_filename
             Http_stack_type(http_stack_position) = Content_typ
             #if Debug_http > 3
                Print "File: " ; Http_get_filename ; " in Stack -> " ; Http_stack_position
             #endif
         Else
            Print "...in HTTP Anfrage  GETFILENAME: " ; Http_get_filename
         End If
      Else
             Http_stack_filename(http_stack_position) = "404.htm"
             Http_stack_type(http_stack_position) = Content_typ
      End If

      ' Auf den HTTP-Stack damit
      Temp_w = Reversed_word(t_ip_pktlen) - 40
      Call Tcp_swap_seq_ack(tcp_seqnum , Tcp_acknum , Temp_w)
      Http_stack_seqnum(http_stack_position) = Tcp_acknum
      Http_stack_acknum(http_stack_position) = Tcp_seqnum
      Http_stack_headerlength(http_stack_position) = 0
      Http_stack_fin(http_stack_position) = 0
      Pos = Proccess_fifo_stack_entry(http_stack_position)
      If Pos = 0 Then
         ' Verbindungswunsch abweisen! FIFO FULL!!!
         ' darf eigentlich nicht passieren!
         ' Set Tcp_rst
         Call Http_reset(http_stack_position)
         #if Debug_http > 1
            Print "ERROR! no FIFO space!"
         #endif
      End If
      #if Debug_http > 1
        Print "--> ACK PSH (GET) " ; Http_stack_filename(http_stack_position) ; " (Stack: " ; Http_stack_position ; " / FIFO: " ; Pos ; ")"
      #endif
End Sub


'-------------------------------------------------------------------------------
' SVG  (Scalable Vector Graphics )
'  erzeugt dynamische, graphische Inhalte und legt diese im Dataload ab
'
'    http://de.wikipedia.org/wiki/Scalable_Vector_Graphics
'    http://svg.tutorial.aptico.de/start3.php?knr=2&kname=Darstellung%20von%20SVG-Grafiken&uknr=2.1&ukname=SVG-Grafiken%20in%20Webdokumenten
' Inhalte ber mehrere Pakete mssen "per Hand" gesteuert werden! siehe Variable Ack_pointer
'
'ACHTUNG! Arbeitet NICHT! mit Magic Quotes! {034} geht nicht!
'-------------------------------------------------------------------------------
#if Include_svg = 1
Function Svg(byval Stack_entry As Byte , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
Local S_s As String * 100
Local X_base As Word
Local Posx1 As Word , Posx2 As Word , Posy1 As Word , Posy2 As Word
Local R As Byte , G As Byte , B As Byte , Pen_width As Byte
Local Temp_sing As Single
Local Minende As Integer
Local Posy1fakt As Word
Local Posy1faktd As Single
      Fn1 = Fs_ev_url + "_b.svg"
      Fn2 = Fs_ev_url + "_e.svg"
      Fn3 = Fs_ev_url + "_bv.svg"
      Fn4 = Fs_ev_url + "_ev.svg"

      If Fs_pulsfaktor = 0 Then
         Posy1fakt = 4
      Else
         If Fs_anlagenleistung = 0 Then
            Posy1fakt = 4
         Else
            Posy1faktd = 65535 / Fs_pulsfaktor
            Posy1faktd = Posy1faktd * 688
            Posy1faktd = Posy1faktd / Fs_anlagenleistung
            Posy1fakt = Posy1faktd
         End If
      End If

      If Http_stack_filename(stack_entry) = "graph1.svg" Then
       If Http_ack_pointer = 1 Then
         Dataload_pointer = Svg_header(dataload_pointer , 530 , 450)       '420 , 240)
         ' Ursprung bei 5, 445

         'let's draw the Graph Lines
         ' X-Axis
'         Call Svg_line(0 , 235 , 375 , 235 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(0 , 445 , 510 , 445 , 2 , 0 , 0 , 0 , Dataload_pointer )
         ' Y-Axis
'         Call Svg_line(5 , 240 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(5 , 450 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )

         'Arrow Y-Axis
'         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         'Arrow X-Axis
 '        S_s = "<polygon points=" + Chr(34) + "400 235 375 230 375 240" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "510 445 485 440 485 450" + Chr(34) + " />" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

         Ack_pointer = 1                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 1 Then
         'einen Verlauf(Path) zeichnen
         Posx1 = 5
         Posx2 = 445
         'Starte Verlauf durch Setzen (moveto) der ersten Koordinate
         Call Svg_begin_path(posx1 , Posx2 , Dataload_pointer)
         Ack_pointer = 2                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
         Posx2 = 0
         'folge Punkte rausbrezeln
       Elseif Ack_pointer = 2 Then
           Minende = Fs_minpos * 2
           Minende = Minende + 4
           If 80 < Minende Then
            Minende = 80
            Ack_pointer = 3
           Else
            Ack_pointer = 8
           End If
           For X_base = 6 To Minende Step 2                 '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw(posx2) / 2
             Posy1 = Fs_minw(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 3 Then
           Minende = Fs_minpos * 2
           Minende = Minende + 4
           If 156 < Minende Then
            Minende = 156
            Ack_pointer = 4
           Else
            Ack_pointer = 8
           End If
           For X_base = 82 To Minende Step 2                '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw(posx2) / 2
             Posy1 = Fs_minw(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 4 Then
           Minende = Fs_minpos * 2
           Minende = Minende + 4
           If 232 < Minende Then
            Minende = 232
            Ack_pointer = 5
           Else
            Ack_pointer = 8
           End If
           For X_base = 158 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw(posx2) / 2
             Posy1 = Fs_minw(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
             Reset Watchdog
           Next
         Svg = 10
       Elseif Ack_pointer = 5 Then
           Minende = Fs_minpos * 2
           Minende = Minende + 4
           If 308 < Minende Then
            Minende = 308
            Ack_pointer = 6
           Else
            Ack_pointer = 8
           End If
           For X_base = 234 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw(posx2) / 2
             Posy1 = Fs_minw(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 6 Then
           Minende = Fs_minpos * 2
           Minende = Minende + 4
           If 384 < Minende Then
            Minende = 384
            Ack_pointer = 7
           Else
            Ack_pointer = 8
           End If
           For X_base = 310 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw(posx2) / 2
             Posy1 = Fs_minw(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
            Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 7 Then
           Minende = Fs_minpos * 2
           Minende = Minende + 4
           If 432 < Minende Then                            'alt: 408
            Minende = 432
           End If
           For X_base = 386 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw(posx2) / 2
              Posy1 = Fs_minw(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
            Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Ack_pointer = 8                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 8 Then
         R = 0
         G = 0
         B = 255
         Pen_width = 1

         'farbe, linienbreite festlegen und beenden
         Call Svg_end_path(pen_width , R , G , B , Dataload_pointer)

         Dataload_pointer = Append_to_dataload(dataload_pointer , "</svg>")
         Ack_pointer = 0
         Svg = 11
       End If


       Elseif Http_stack_filename(stack_entry) = "graph1v.svg" Then
       If Http_ack_pointer = 1 Then
         Dataload_pointer = Svg_header(dataload_pointer , 530 , 450)       '420 , 240)
         ' Ursprung bei 5, 445

         'let's draw the Graph Lines
         ' X-Axis
'         Call Svg_line(0 , 235 , 375 , 235 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(0 , 445 , 510 , 445 , 2 , 0 , 0 , 0 , Dataload_pointer )
         ' Y-Axis
'         Call Svg_line(5 , 240 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(5 , 450 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )

         'Arrow Y-Axis
'         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         'Arrow X-Axis
 '        S_s = "<polygon points=" + Chr(34) + "400 235 375 230 375 240" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "510 445 485 440 485 450" + Chr(34) + " />" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

         Ack_pointer = 1                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 1 Then
         'einen Verlauf(Path) zeichnen
         Posx1 = 5
         Posx2 = 445
         'Starte Verlauf durch Setzen (moveto) der ersten Koordinate
         Call Svg_begin_path(posx1 , Posx2 , Dataload_pointer)
         Ack_pointer = 2                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
         Posx2 = 0
         'folge Punkte rausbrezeln
       Elseif Ack_pointer = 2 Then
           Minende = 216 * 2
           Minende = Minende + 4
           If 80 < Minende Then
            Minende = 80
            Ack_pointer = 3
           Else
            Ack_pointer = 8
           End If
           For X_base = 6 To Minende Step 2                 '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw_vt(posx2) / 2
             Posy1 = Fs_minw_vt(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 3 Then
           Minende = 216 * 2
           Minende = Minende + 4
           If 156 < Minende Then
            Minende = 156
            Ack_pointer = 4
           Else
            Ack_pointer = 8
           End If
           For X_base = 82 To Minende Step 2                '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw_vt(posx2) / 2
             Posy1 = Fs_minw_vt(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 4 Then
           Minende = 216 * 2
           Minende = Minende + 4
           If 232 < Minende Then
            Minende = 232
            Ack_pointer = 5
           Else
            Ack_pointer = 8
           End If
           For X_base = 158 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw_vt(posx2) / 2
             Posy1 = Fs_minw_vt(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
             Reset Watchdog
           Next
         Svg = 10
       Elseif Ack_pointer = 5 Then
           Minende = 216 * 2
           Minende = Minende + 4
           If 308 < Minende Then
            Minende = 308
            Ack_pointer = 6
           Else
            Ack_pointer = 8
           End If
           For X_base = 234 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw_vt(posx2) / 2
             Posy1 = Fs_minw_vt(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 6 Then
           Minende = 216 * 2
           Minende = Minende + 4
           If 384 < Minende Then
            Minende = 384
            Ack_pointer = 7
           Else
            Ack_pointer = 8
           End If
           For X_base = 310 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw_vt(posx2) / 2
             Posy1 = Fs_minw_vt(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 7 Then
           Minende = 216 * 2
           Minende = Minende + 4
           If 432 < Minende Then                            'alt: 408
            Minende = 432
           End If
           For X_base = 386 To Minende Step 2               '414 Step 2
             Incr Posx2
'             Posy1 = Fs_minw_vt(posx2) / 2
             Posy1 = Fs_minw_vt(posx2) * Posy1fakt
             Posy1 = Posy1 / 8
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Ack_pointer = 8                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 8 Then
         R = 0
         G = 0
         B = 255
         Pen_width = 1

         'farbe, linienbreite festlegen und beenden
         Call Svg_end_path(pen_width , R , G , B , Dataload_pointer)

         Dataload_pointer = Append_to_dataload(dataload_pointer , "</svg>")
         Ack_pointer = 0
         Svg = 11
       End If




      Elseif Http_stack_filename(stack_entry) = Fn1 Then
       If Http_ack_pointer = 1 Then
         Dataload_pointer = Svg_header(dataload_pointer , 680 , 450)       '420 , 240)
         ' Ursprung bei 5, 445

         'let's draw the Graph Lines
         ' X-Axis
'         Call Svg_line(0 , 235 , 375 , 235 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(0 , 445 , 660 , 445 , 2 , 0 , 0 , 0 , Dataload_pointer )
         ' Y-Axis
'         Call Svg_line(5 , 240 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(5 , 450 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )

         'Arrow Y-Axis
'         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         'Arrow X-Axis
 '        S_s = "<polygon points=" + Chr(34) + "400 235 375 230 375 240" + Chr(34) + " />" + Cr_lf
'          S_s = "<polygon points=" + Chr(34) + "510 445 485 440 485 450" + Chr(34) + " />" + Cr_lf
          S_s = "<polygon points=" + Chr(34) + "660 595 635 590 635 600" + Chr(34) + " />" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

         Ack_pointer = 1                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 1 Then
         'einen Verlauf(Path) zeichnen
         Posx1 = 5
         Posx2 = 445
         'Starte Verlauf durch Setzen (moveto) der ersten Koordinate
         Call Svg_begin_path(posx1 , Posx2 , Dataload_pointer)
         Ack_pointer = 2                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
         Posx2 = 0
         'folge Punkte rausbrezeln
       Elseif Ack_pointer = 2 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 80 < Minende Then
            Minende = 80
            Ack_pointer = 3
           Else
            Ack_pointer = 10
           End If
           For X_base = 6 To Minende Step 2                 '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 3 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 156 < Minende Then
            Minende = 156
            Ack_pointer = 4
           Else
            Ack_pointer = 10
           End If
           For X_base = 82 To Minende Step 2                '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 4 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 232 < Minende Then
            Minende = 232
            Ack_pointer = 5
           Else
            Ack_pointer = 10
           End If
           For X_base = 158 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 5 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 308 < Minende Then
            Minende = 308
            Ack_pointer = 6
           Else
            Ack_pointer = 10
           End If
           For X_base = 234 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 6 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 384 < Minende Then
            Minende = 384
            Ack_pointer = 7
           Else
            Ack_pointer = 10
           End If
           For X_base = 310 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 7 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 460 < Minende Then                            'alt: 408
            Minende = 460
            Ack_pointer = 8                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 386 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 8 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 536 < Minende Then                            'alt: 408
            Minende = 536
            Ack_pointer = 9                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 462 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 9 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 576 < Minende Then                            'alt: 408
            Minende = 576
           End If
           For X_base = 538 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Ack_pointer = 10                                   'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 10 Then
         R = 0
         G = 0
         B = 255
         Pen_width = 1

         'farbe, linienbreite festlegen und beenden
         Call Svg_end_path(pen_width , R , G , B , Dataload_pointer)

         Dataload_pointer = Append_to_dataload(dataload_pointer , "</svg>")
         Ack_pointer = 0
         Svg = 11
       End If


      Elseif Http_stack_filename(stack_entry) = Fn2 Then
       If Http_ack_pointer = 1 Then
         Dataload_pointer = Svg_header(dataload_pointer , 680 , 450)       '420 , 240)
         ' Ursprung bei 5, 445

         'let's draw the Graph Lines
         ' X-Axis
'         Call Svg_line(0 , 235 , 375 , 235 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(0 , 445 , 660 , 445 , 2 , 0 , 0 , 0 , Dataload_pointer )
         ' Y-Axis
'         Call Svg_line(5 , 240 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(5 , 450 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )

         'Arrow Y-Axis
'         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         'Arrow X-Axis
 '        S_s = "<polygon points=" + Chr(34) + "400 235 375 230 375 240" + Chr(34) + " />" + Cr_lf
'          S_s = "<polygon points=" + Chr(34) + "510 445 485 440 485 450" + Chr(34) + " />" + Cr_lf
          S_s = "<polygon points=" + Chr(34) + "660 595 635 590 635 600" + Chr(34) + " />" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

         Ack_pointer = 1                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 1 Then
         'einen Verlauf(Path) zeichnen
         Posx1 = 5
         Posx2 = 445
         'Starte Verlauf durch Setzen (moveto) der ersten Koordinate
         Call Svg_begin_path(posx1 , Posx2 , Dataload_pointer)
         Ack_pointer = 2                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
         Posx2 = 0
         'folge Punkte rausbrezeln
       Elseif Ack_pointer = 2 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 80 < Minende Then
            Minende = 80
            Ack_pointer = 3
           Else
            Ack_pointer = 10
           End If
           For X_base = 6 To Minende Step 2                 '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 3 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 156 < Minende Then
            Minende = 156
            Ack_pointer = 4
           Else
            Ack_pointer = 10
           End If
           For X_base = 82 To Minende Step 2                '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 4 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 232 < Minende Then
            Minende = 232
            Ack_pointer = 5
           Else
            Ack_pointer = 10
           End If
           For X_base = 158 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 5 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 308 < Minende Then
            Minende = 308
            Ack_pointer = 6
           Else
            Ack_pointer = 10
           End If
           For X_base = 234 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 6 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 384 < Minende Then
            Minende = 384
            Ack_pointer = 7
           Else
            Ack_pointer = 10
           End If
           For X_base = 310 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 7 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 460 < Minende Then                            'alt: 408
            Minende = 460
            Ack_pointer = 8                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 386 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 8 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 536 < Minende Then                            'alt: 408
            Minende = 536
            Ack_pointer = 9                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 462 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 9 Then
           Minende = Fs_minpos_bez * 2
           Minende = Minende + 4
           If 576 < Minende Then                            'alt: 408
            Minende = 576
           End If
           For X_base = 538 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Ack_pointer = 10                                   'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 10 Then
         R = 0
         G = 0
         B = 255
         Pen_width = 1
        'farbe, linienbreite festlegen und beenden
         Call Svg_end_path(pen_width , R , G , B , Dataload_pointer)

         Dataload_pointer = Append_to_dataload(dataload_pointer , "</svg>")
         Ack_pointer = 0
         Svg = 11
       End If


         Elseif Http_stack_filename(stack_entry) = Fn3 Then
       If Http_ack_pointer = 1 Then
         Dataload_pointer = Svg_header(dataload_pointer , 680 , 450)       '420 , 240)
         ' Ursprung bei 5, 445

         'let's draw the Graph Lines
         ' X-Axis
'         Call Svg_line(0 , 235 , 375 , 235 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(0 , 445 , 660 , 445 , 2 , 0 , 0 , 0 , Dataload_pointer )
         ' Y-Axis
'         Call Svg_line(5 , 240 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(5 , 450 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )

         'Arrow Y-Axis
'         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         'Arrow X-Axis
 '        S_s = "<polygon points=" + Chr(34) + "400 235 375 230 375 240" + Chr(34) + " />" + Cr_lf
'          S_s = "<polygon points=" + Chr(34) + "510 445 485 440 485 450" + Chr(34) + " />" + Cr_lf
          S_s = "<polygon points=" + Chr(34) + "660 595 635 590 635 600" + Chr(34) + " />" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

         Ack_pointer = 1                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 1 Then
         'einen Verlauf(Path) zeichnen
         Posx1 = 5
         Posx2 = 445
         'Starte Verlauf durch Setzen (moveto) der ersten Koordinate
         Call Svg_begin_path(posx1 , Posx2 , Dataload_pointer)
         Ack_pointer = 2                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
         Posx2 = 0
         'folge Punkte rausbrezeln
       Elseif Ack_pointer = 2 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 80 < Minende Then
            Minende = 80
            Ack_pointer = 3
           Else
            Ack_pointer = 10
           End If
           For X_base = 6 To Minende Step 2                 '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 3 Then
           Minende = 288 * 2
          Minende = Minende + 4
           If 156 < Minende Then
            Minende = 156
            Ack_pointer = 4
           Else
            Ack_pointer = 10
           End If
           For X_base = 82 To Minende Step 2                '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 4 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 232 < Minende Then
            Minende = 232
            Ack_pointer = 5
           Else
            Ack_pointer = 10
           End If
           For X_base = 158 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 5 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 308 < Minende Then
            Minende = 308
            Ack_pointer = 6
           Else
            Ack_pointer = 10
           End If
           For X_base = 234 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 6 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 384 < Minende Then
            Minende = 384
            Ack_pointer = 7
           Else
            Ack_pointer = 10
           End If
           For X_base = 310 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 7 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 460 < Minende Then                            'alt: 408
            Minende = 460
            Ack_pointer = 8                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 386 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 8 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 536 < Minende Then                            'alt: 408
            Minende = 536
            Ack_pointer = 9                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 462 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 9 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 576 < Minende Then                            'alt: 408
            Minende = 576
           End If
           For X_base = 538 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_bezug_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Ack_pointer = 10                                   'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 10 Then
         R = 0
         G = 0
         B = 255
         Pen_width = 1

         'farbe, linienbreite festlegen und beenden
         Call Svg_end_path(pen_width , R , G , B , Dataload_pointer)

         Dataload_pointer = Append_to_dataload(dataload_pointer , "</svg>")
         Ack_pointer = 0
         Svg = 11
       End If


      Elseif Http_stack_filename(stack_entry) = Fn4 Then
       If Http_ack_pointer = 1 Then
         Dataload_pointer = Svg_header(dataload_pointer , 680 , 450)       '420 , 240)
         ' Ursprung bei 5, 445

         'let's draw the Graph Lines
         ' X-Axis
'         Call Svg_line(0 , 235 , 375 , 235 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(0 , 445 , 660 , 445 , 2 , 0 , 0 , 0 , Dataload_pointer )
         ' Y-Axis
'         Call Svg_line(5 , 240 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )
          Call Svg_line(5 , 450 , 5 , 25 , 2 , 0 , 0 , 0 , Dataload_pointer )

         'Arrow Y-Axis
'         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
         S_s = "<polygon points=" + Chr(34) + "5 0 0 25 10 25" + Chr(34) + " />" + Cr_lf
                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         'Arrow X-Axis
 '        S_s = "<polygon points=" + Chr(34) + "400 235 375 230 375 240" + Chr(34) + " />" + Cr_lf
'          S_s = "<polygon points=" + Chr(34) + "510 445 485 440 485 450" + Chr(34) + " />" + Cr_lf
          S_s = "<polygon points=" + Chr(34) + "660 595 635 590 635 600" + Chr(34) + " />" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

         Ack_pointer = 1                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 1 Then
         'einen Verlauf(Path) zeichnen
         Posx1 = 5
         Posx2 = 445
         'Starte Verlauf durch Setzen (moveto) der ersten Koordinate
         Call Svg_begin_path(posx1 , Posx2 , Dataload_pointer)
         Ack_pointer = 2                                    'Paket voll! auf zweites Paket umschalten
         Svg = 10
         Posx2 = 0
         'folge Punkte rausbrezeln
       Elseif Ack_pointer = 2 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 80 < Minende Then
            Minende = 80
            Ack_pointer = 3
           Else
            Ack_pointer = 10
           End If
           For X_base = 6 To Minende Step 2                 '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 3 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 156 < Minende Then
            Minende = 156
            Ack_pointer = 4
           Else
            Ack_pointer = 10
           End If
           For X_base = 82 To Minende Step 2                '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 4 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 232 < Minende Then
            Minende = 232
            Ack_pointer = 5
           Else
            Ack_pointer = 10
           End If
           For X_base = 158 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 5 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 308 < Minende Then
            Minende = 308
            Ack_pointer = 6
           Else
            Ack_pointer = 10
           End If
           For X_base = 234 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 6 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 384 < Minende Then
            Minende = 384
            Ack_pointer = 7
           Else
            Ack_pointer = 10
           End If
           For X_base = 310 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 7 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 460 < Minende Then                            'alt: 408
            Minende = 460
            Ack_pointer = 8                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 386 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 8 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 536 < Minende Then                            'alt: 408
            Minende = 536
            Ack_pointer = 9                                 'Paket voll! auf zweites Paket umschalten
           Else
            Ack_pointer = 10
           End If
           For X_base = 462 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Svg = 10
       Elseif Ack_pointer = 9 Then
           Minende = 288 * 2
           Minende = Minende + 4
           If 576 < Minende Then                            'alt: 408
            Minende = 576
           End If
           For X_base = 538 To Minende Step 2               '414 Step 2
             Incr Posx2
             'Bereich bis 80C
             Posy1 = Fs_min_einspeis_vt(posx2) / 2
             Posy1 = 445 - Posy1
             S_s = " L" + Str(x_base) + "," + Str(posy1)
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next
         Ack_pointer = 10                                   'Paket voll! auf zweites Paket umschalten
         Svg = 10
       Elseif Ack_pointer = 10 Then
         R = 0
         G = 0
         B = 255
         Pen_width = 1
        'farbe, linienbreite festlegen und beenden
         Call Svg_end_path(pen_width , R , G , B , Dataload_pointer)

         Dataload_pointer = Append_to_dataload(dataload_pointer , "</svg>")
         Ack_pointer = 0
         Svg = 11
       End If

      End If
End Function

Sub Svg_begin_path(byval X1 As Word , Byval Y1 As Word , Byref Dataload_pointer As Word)
Local S_s As String * 100
      S_s = "<path d=" + Chr(34) + "M" + Str(x1) + "," + Str(y1)
      Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
End Sub

Sub Svg_end_path(byval Width As Byte , Byval Red As Byte , Byval Green As Byte , Byval Blue As Byte , Byref Dataload_pointer As Word)
Local S_s As String * 100
'      S_s = " Z" + Chr(34) + " stroke=" + Chr(34) + "rgb(" + Str(red) + "," + Str(green) + "," + Str(blue) + ")" + Chr(34) + " stroke-width=" + Chr(34) + Str(width) + "px" + Chr(34) + " fill=" + Chr(34) + "none" + Chr(34) + " />" + Cr_lf
      S_s = Chr(34) + " stroke=" + Chr(34) + "rgb(" + Str(red) + "," + Str(green) + "," + Str(blue) + ")" + Chr(34) + " stroke-width=" + Chr(34) + Str(width) + "px" + Chr(34) + " fill=" + Chr(34) + "none" + Chr(34) + " />" + Cr_lf
      Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
End Sub

Sub Svg_line(byval X1 As Word , Byval Y1 As Word , Byval X2 As Word , Byval Y2 As Word , Byval Width As Byte , Byval Red As Byte , Byval Green As Byte , Byval Blue As Byte , Byref Dataload_pointer As Word)
Local S_s As String * 100
         S_s = "<line x1=" + Chr(34) + Str(x1) + Chr(34) + " y1=" + Chr(34) + Str(y1) + Chr(34) + " x2=" + Chr(34) + Str(x2) + Chr(34) + " y2=" + Chr(34) + Str(y2) + Chr(34)
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = " stroke=" + Chr(34) + "rgb(" + Str(red) + "," + Str(green) + "," + Str(blue) + ")" + Chr(34) + " stroke-width=" + Chr(34) + Str(width) + "px" + Chr(34) + " />" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
End Sub

Function Svg_header(byref Dataload_pointer As Word , Byval Width As Word , Byval Height As Word) As Word
Local S_s As String * 100
'
'ACHTUNG! Arbeitet NICHT! mit Magic Quotes! {034} geht nicht!
         S_s = "<?xml version={034}1.0{034} encoding={034}ISO-8859-1{034}?>"
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = "<svg xmlns=" + Chr(34) + "http://www.w3.org/2000/svg" + Chr(34) + " xmlns:xlink=" + Chr(34) + "http://www.w3.org/1999/xlink" + Chr(34)
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = " xmlns:ev=" + Chr(34) + "http://www.w3.org/2001/xml-events" + Chr(34) + " version=" + Chr(34) + "1.1" + Chr(34)
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = " baseProfile=" + Chr(34) + "full" + Chr(34) + " width=" + Chr(34) + Str(width) + "px" + Chr(34) + " height=" + Chr(34) + Str(height) + "px" + Chr(34)
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = "  viewBox=" + Chr(34) + "0 0 " + Str(width) + " " + Str(height) + "" + Chr(34) + ">" + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         Svg_header = Dataload_pointer
End Function

#endif

'-------------------------------------------------------------------------------
' Javascript
'  erzeugt dynamische Inhalte und legt diese im Dataload ab
'  FIN Flag wird sofort gesetzt!
'-------------------------------------------------------------------------------
#if Include_javascript = 1
Function Javascript(byval Stack_entry As Byte , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
  Local S_s As String * 50
  Local I As Integer
  Local J As Integer
  Local K As Integer
  Local K2 As Integer
  Local K3 As Integer
  Local M As Integer
  Local M2 As Integer
  Local L As Long
  Local L2 As Long
  Local L3 As Long
  Local W As Word
  Local S2 As String * 10
  Local S3 As String * 10
  Local S4 As String * 10
  Local Loop1 As Integer
  Local Loop2 As Integer
  Local B As Byte
  Local Sing As Single
  Local Flag As Integer
  Local Il As Long
  Local Jl As Long


         Fn1 = Fs_ev_url + "_b.js"                          'Filename 5min Werte Bezug
         Fn2 = Fs_ev_url + "_e.js"                          'Filename 5min Werte Einspeis
         Fn3 = Fs_ev_url + "_bv.js"                         'Filename 5min Werte Bezug Vortag
         Fn4 = Fs_ev_url + "_ev.js"                         'Filename 5min Werte Einspeis     'vortag
         Fn5 = Fs_ev_url + "_ue.js"                         'Filename Eigenverbrauch berblick
         Fn6 = Fs_ev_url + "_bt.js"                         'Filename Eigenverbrauch berblick
         Fn7 = Fs_ev_url + "_et.js"                         'Filename Eigenverbrauch berblick
         Fn8 = Fs_ev_url + "_2b.js"                         'Filename Bezug akt. Leistung
         Fn9 = Fs_ev_url + "_4b.js"                         'Filename Bezug Tagesenergie
         Fn10 = Fs_ev_url + "_2e.js"                        'Filename Einspeisung akt. Leistung
         Fn11 = Fs_ev_url + "_4e.js"                        'Filename Einspeisung Tagesenergie
         Fn12 = Fs_ev_url + "_1a.js"                        'Filename Datum, Zeit, Solar akt. Leist, Solar Tag, Solar Vortag,Bezug akt. Leist, Bezug Tag, Bezug Vortag,Einspeis akt. Leist, Einspeis Tag, Einspeis Vortag,


    'Dynamische Inhalte einfgen
         B = 0

         Select Case Http_stack_filename(stack_entry)
                Case "base_vars.js" :
                              S_s = "var DATALOGGER_NAME=" + Chr(34) + "FreeSol" + Chr(34) + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = "var DATALOGGER_VERSION=" + Chr(34) + Fs_version + Chr(34) + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = "var AnzahlWR=1" + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                          Base1:
                              S3 = Str(fs_anlagenleistung)
                              S4 = Str(fs_anlagenleistung)
                              If S3 <> S4 Then
                                 Goto Base1
                              End If
                              S_s = "var AnlagenKWP=" + S3 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = "var WRInfo = new Array(AnzahlWR)" + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = "WRInfo[0]=new Array(" + Chr(34) + "unknown" + Chr(34) + "," + Chr(34) + "???" + Chr(34)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = "," + Str(fs_anlagenleistung) + ",0," + Chr(34) + "unknown" + Chr(34) + ",1,"
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = "null,null,0,null,1,0,0,1000,null) " + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
                Case "months.js" :
                             ' laufenden Monat neu berechnen
                              Fs_lfdmonwerte = 0
                              L = Sysday(netio_time)
                              L = L Mod 100                   ' 5-8-12 Bug korrigiert (10)
                              I = L
                              K2 = _day - 1
                              For K = 1 To K2
                                 J = 100 - K
                                 J = J + I
                                 J = J Mod 100               ' 5-8-12 Bug korrigiert (10)
                                 If J = 0 Then              ' 5-8-12 Bug korrigiert (10)
                                    J = 100
                                 End If
                                 Fs_lfdmonwerte = Fs_lfdmonwerte + Fs_tageswerte(j)
                              Next J
                              Fs_lfdmonwerte = Fs_lfdmonwerte * 10
                              Fs_lfdmonwerte = Fs_lfdmonwerte + Fs_pulszahl
                              Fs_lfdmonwerte = Fs_lfdmonwerte - Fs_stundenstart(1)
                              Fs_speicherdat_lfdmon = Sysday(netio_time)
                              W = Fs_speicherdat_lfdmon
                              S2 = Date(w)
                          Months1:
                              S3 = Str(fs_lfdmonwerte)
                              S4 = Str(fs_lfdmonwerte)
                              If S3 <> S4 Then
                                 Goto Months1
                              End If
                              S_s = "mo[mx++]=" + Chr(34) + S2 + "|" + S3 + Chr(34) + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              W = Fs_speicherdatum_monate
                              S2 = Date(w)
                          Months2:
                              S3 = Str(fs_monatswerte)
                              S4 = Str(fs_monatswerte)
                              If S3 <> S4 Then
                                 Goto Months2
                              End If
                              S_s = "mo[mx++]=" + Chr(34) + S2 + "|" + S3 + Chr(34) + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
                Case "days_hist.js" :
                           ' Nutzlast wohl max ca 1500 byte
                              If Fs_tagesmax > 0 Then
                               If Ntp_valid = 1 Then
                                If Fs_speicherdatum_tage > 0 Then
                                K = Fs_tagesmax - 1

                                ' 50 geht schon nicht mehr
                                If K > 40 Then
                                   K = 40
                                End If



                                 For J = 0 To K             '9
                                  L = Fs_speicherdatum_tage - J
                                  W = L
                                  S2 = Date(w)
                                  L2 = L Mod 100             ' 5-8-12 Bug korrigiert (11)
                                  I = L2
                                  If I = 0 Then             ' 5-8-12 Bug korrigiert (11)
                                     I = 100
                                  End If
                                  L = Fs_tageswerte(i) * 10
                           Days1:
                                  S3 = Str(l)
                                  S4 = Str(l)
                                  If S3 <> S4 Then
                                      Goto Days1
                                  End If
                                  S_s = "da[dx++]=" + Chr(34) + S2 + "|" + S3 + ";0000" + Chr(34) + Chr(13) + Chr(10)
                                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                                 Next J



                                End If
                               End If
                              End If
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
                Case Fn6:
                           ' Nutzlast wohl max ca 1500 byte
                               If Ntp_valid = 1 Then
                                If Fs_bezug_speichdat_t > 0 Then
                                K = 29                      ' 50 geht schon nicht mehr
                                 For J = 0 To K             '9
                                  L = Fs_bezug_speichdat_t - J
                                  W = L
                                  S2 = Date(w)
                                  L2 = L Mod 30             ' 5-8-12 Bug korrigiert (12)
                                  I = L2
                                  If I = 0 Then             ' 5-8-12 Bug korrigiert (12)
                                     I = 30
                                  End If

                                  L = Fs_bezug_tagesstand(i) * 10
                           Days2:
                                  S3 = Str(l)
                                  S4 = Str(l)
                                  If S3 <> S4 Then
                                      Goto Days2
                                  End If
                                  S_s = S2 + ";" + S3 + ";" + Chr(13) + Chr(10)
                                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                                 Next J
                                End If
                               End If
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
               Case Fn5 :
                           ' Nutzlast wohl max ca 1500 byte
                               If Ntp_valid = 1 Then
                                If Fs_bezug_speichdat_t > 0 Then

                                S_s = "Werte in Wh" + Chr(13) + Chr(10)
                                Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                                S_s = "Datum  Erzeug  Bezug  Einsp  EigenVerb  GesVerb" + Chr(13) + Chr(10)       '49 Zeichen Mit Crlf
                                Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                                K = 10                      ' 50 geht schon nicht mehr
                                For J = 0 To K              '9
                                  L = Fs_bezug_speichdat_t - J       'zu druckender Tag in der Loop von 10 tagen

                                  L2 = L Mod 30             ' 5-8-12 Bug korrigiert (13)
                                  I = L2                    'Speicherstelle fr Bezug und Einspeisung
                                  If I = 0 Then             ' 5-8-12 Bug korrigiert (13)
                                     I = 30
                                  End If


                                  L3 = L Mod 100            ' 5-8-12 Bug korrigiert (14)
                                  M2 = L3                   'Speicherstelle fr Erzeugung  (Vortag nehmen!)
                                  M2 = M2 + 99              'Speicherstelle fr Erzeugung  (Vortag nehmen! -1 = +99)
                                  M2 = M2 Mod 100           ' 5-8-12 Bug korrigiert (14) gendert!
                                  If M2 = 0 Then            ' 5-8-12 Bug korrigiert (14)
                                     M2 = 100
                                  End If


                                  L2 = L + 29               'Vortag nehmen! -1 = +29
                                  L2 = L2 Mod 30            ' 5-8-12 Bug korrigiert (15)
                                  M = L2                    'Speicherstelle Vortag fr Bezug und Einspeisung
                                  If M = 0 Then             ' 5-8-12 Bug korrigiert (15)
                                     M = 30
                                  End If

                                  W = L
                                  W = W - 1
                                  S2 = Date(w)

                                  'Erzeug
                                  L = Fs_tageswerte(m2) * 10
                           Days6:
                                  S3 = Str(l)
                                  S4 = Str(l)
                                  If S3 <> S4 Then
                                    Goto Days6
                                  End If
                                  S_s = S2 + "  " + S3

                                  ' Bezug
                                  L = Fs_bezug_tagesstand(i)
                                  L3 = Fs_bezug_tagesstand(m)
                                  L = L - L3
                           Days4:
                                  Flag = 0
                                  If L > 500000 Then
                                    Flag = 1
                                  End If
                                  If L < 0 Then
                                    Flag = 1
                                  End If

                                  If Flag = 0 Then
                                   S3 = Str(l)
                                   S4 = Str(l)
                                   If S3 <> S4 Then
                                   Goto Days4
                                   End If
                                  Else
                                    S3 = "0"
                                  End If
                                  S_s = S_s + "  " + S3

                                  'Einspeis
                                  L = Fs_einspeis_tagesstand(i)
                                  L3 = Fs_einspeis_tagesstand(m)
                                  L = L - L3
                           Days5:
                                  Flag = 0
                                  If L > 500000 Then
                                    Flag = 1
                                  End If
                                  If L < 0 Then
                                    Flag = 1
                                  End If

                                  If Flag = 0 Then
                                     S3 = Str(l)
                                     S4 = Str(l)
                                     If S3 <> S4 Then
                                         Goto Days5
                                     End If
                                  Else
                                    S3 = "0"
                                  End If

                                  S_s = S_s + "  " + S3

                                  'Solarer Verbrauch
                                  L = Fs_tageswerte(m2) * 10
                                  L2 = Fs_einspeis_tagesstand(i)
                                  L3 = Fs_einspeis_tagesstand(m)
                                  L2 = L2 - L3
                                  L = L - L2
                           Days7:
                                  Flag = 0
                                  If L > 500000 Then
                                    Flag = 1
                                  End If
                                  If L < 0 Then
                                    Flag = 1
                                  End If

                                  If Flag = 0 Then
                                     S3 = Str(l)
                                     S4 = Str(l)
                                     If S3 <> S4 Then
                                         Goto Days7
                                     End If
                                  Else
                                    S3 = "0"
                                  End If

                                  S_s = S_s + "  " + S3

                                  'Gesamtverbrauch = Solarer verbrauch + Bezug
                                  L2 = Fs_bezug_tagesstand(i)
                                  L3 = Fs_bezug_tagesstand(m)
                                  L = L + L2
                                  L = L - L3
                           Days8:
                                  Flag = 0
                                  If L > 500000 Then
                                    Flag = 1
                                  End If
                                  If L < 0 Then
                                    Flag = 1
                                  End If

                                  If Flag = 0 Then
                                     S3 = Str(l)
                                     S4 = Str(l)
                                     If S3 <> S4 Then
                                         Goto Days8
                                     End If
                                  Else
                                    S3 = "0"
                                  End If

                                  S_s = S_s + "  " + S3
                                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                                  S_s = Chr(13) + Chr(10)
                                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                                 Next J
                                End If
                               End If
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
                Case Fn7:
                           ' Nutzlast wohl max ca 1500 byte
                               If Ntp_valid = 1 Then
                                If Fs_einspeis_speichdat_t > 0 Then
                                K = 29                      ' 50 geht schon nicht mehr

                                 For J = 0 To K             '9
                                  L = Fs_einspeis_speichdat_t - J
                                  W = L
                                  S2 = Date(w)
                                  L2 = L Mod 30
                                  I = L2
                                  If I = 0 Then             ' 5-8-12 Bug korrigiert (16)
                                     I = 30
                                  End If

                                  L = Fs_einspeis_tagesstand(i) * 10
                           Days3:
                                  S3 = Str(l)
                                  S4 = Str(l)
                                  If S3 <> S4 Then
                                      Goto Days3
                                  End If
                                  S_s = S2 + ";" + S3 + ";" + Chr(13) + Chr(10)
                                  Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                                 Next J
                                End If
                               End If
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
                Case "minutes.js"
                           Minutes4:
                              S2 = Date(netio_time)
                              S3 = Date(netio_time)
                              If S2 <> S3 Then
                                 Goto Minutes4
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              For J = 0 To 17
                                 J = J + 4
                           Minutes1:
                                 S2 = Str(j)
                                 S3 = Str(j)
                                 If S2 <> S3 Then
                                    Goto Minutes1
                                 End If
                                 S_s = S2 + ": "            ' 4 Byte
                                 J = J - 4
                                 For I = 1 To 6
                                    K = 12 * J
                                    K = K + I
                                    If Fs_pulsfaktor <> 1000 Then
                                       Sing = Fs_minw(k)
                                       Sing = Sing * 1000
                                       Sing = Sing / Fs_pulsfaktor
                                       K3 = Sing
                                    Else
                                       K3 = Fs_minw(k)
                                    End If
                           Minutes2:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Minutes2
                                    End If
                                    S_s = S_s + S2 + "  "   ' 5 Byte
                                 Next I
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)       '30 Byte
                                 S_s = ""
                                 For I = 7 To 12
                                    K = 12 * J
                                    K = K + I
                                    If Fs_pulsfaktor <> 1000 Then
                                       Sing = Fs_minw(k)
                                       Sing = Sing * 1000
                                       Sing = Sing / Fs_pulsfaktor
                                       K3 = Sing
                                    Else
                                       K3 = Fs_minw(k)
                                    End If
                           Minutes3:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Minutes3
                                    End If

                                    S_s = S_s + S2 + "  "   '5 Byte
                                 Next I
                                 S_s = S_s + + Chr(13) + Chr(10)       '2 Byte
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Next J
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
    Case "minutesv.js"
                           Minutes4v:
                              W = Fs_speichdat_vt_t
                              S2 = Date(w)
                              S3 = Date(w)
                              If S2 <> S3 Then
                                 Goto Minutes4v
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              For J = 0 To 17
                                 J = J + 4
                           Minutes1v:
                                 S2 = Str(j)
                                 S3 = Str(j)
                                 If S2 <> S3 Then
                                    Goto Minutes1v
                                 End If
                                 S_s = S2 + ": "            ' 4 Byte
                                 J = J - 4
                                 For I = 1 To 6
                                    K = 12 * J
                                    K = K + I
                                    If Fs_pulsfaktor <> 1000 Then
                                       Sing = Fs_minw_vt(k)
                                       Sing = Sing * 1000
                                       Sing = Sing / Fs_pulsfaktor
                                       K3 = Sing
                                    Else
                                       K3 = Fs_minw_vt(k)
                                    End If
                           Minutes2v:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Minutes2v
                                    End If
                                    S_s = S_s + S2 + "  "   ' 5 Byte
                                 Next I
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)       '30 Byte
                                 S_s = ""
                                 For I = 7 To 12
                                    K = 12 * J
                                    K = K + I
                                    If Fs_pulsfaktor <> 1000 Then
                                       Sing = Fs_minw_vt(k)
                                       Sing = Sing * 1000
                                       Sing = Sing / Fs_pulsfaktor
                                       K3 = Sing
                                    Else
                                       K3 = Fs_minw_vt(k)
                                    End If
                           Minutes3v:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Minutes3v
                                    End If

                                    S_s = S_s + S2 + "  "   '5 Byte
                                 Next I
                                 S_s = S_s + + Chr(13) + Chr(10)       '2 Byte
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Next J
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

               Case Fn1
                           Min_bez4:
                              S2 = Date(netio_time)
                              S3 = Date(netio_time)
                              If S2 <> S3 Then
                                 Goto Min_bez4
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              For J = 0 To 23
                           Min_bez1:
                                 S2 = Str(j)
                                 S3 = Str(j)
                                 If S2 <> S3 Then
                                    Goto Min_bez1
                                 End If
                                 S_s = S2 + ": "            ' 4 Byte
                                 For I = 1 To 6
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_bezug(k)
                           Min_bez2:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_bez2
                                    End If
                                    S_s = S_s + S2 + "  "   ' 5 Byte
                                 Next I
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)       '30 Byte
                                 S_s = ""
                                 For I = 7 To 12
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_bezug(k)
                           Min_bez3:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_bez3
                                    End If

                                    S_s = S_s + S2 + "  "   '5 Byte
                                 Next I
                                 S_s = S_s + + Chr(13) + Chr(10)       '2 Byte
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Next J
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

               Case Fn2
                           Min_einsp4:
                              S2 = Date(netio_time)
                              S3 = Date(netio_time)
                              If S2 <> S3 Then
                                 Goto Min_einsp4
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              For J = 0 To 23
                           Min_einsp1:
                                 S2 = Str(j)
                                 S3 = Str(j)
                                 If S2 <> S3 Then
                                    Goto Min_einsp1
                                 End If
                                 S_s = S2 + ": "            ' 4 Byte
                                 For I = 1 To 6
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_einspeis(k)
                           Min_einsp2:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_einsp2
                                    End If
                                    S_s = S_s + S2 + "  "   ' 5 Byte
                                 Next I
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)       '30 Byte
                                 S_s = ""
                                 For I = 7 To 12
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_einspeis(k)
                           Min_einsp3:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_einsp3
                                    End If

                                    S_s = S_s + S2 + "  "   '5 Byte
                                 Next I
                                 S_s = S_s + + Chr(13) + Chr(10)       '2 Byte
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Next J
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

               Case Fn3
                           Min_bez4v:
                              W = Fs_speichdat_vt_t
                              S2 = Date(w)
                              S3 = Date(w)
                              If S2 <> S3 Then
                                 Goto Min_bez4v
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              For J = 0 To 23
                           Min_bez1v:
                                 S2 = Str(j)
                                 S3 = Str(j)
                                 If S2 <> S3 Then
                                    Goto Min_bez1v
                                 End If
                                 S_s = S2 + ": "            ' 4 Byte
                                 For I = 1 To 6
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_bezug_vt(k)
                           Min_bez2v:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_bez2v
                                    End If
                                    S_s = S_s + S2 + "  "   ' 5 Byte
                                 Next I
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)       '30 Byte
                                 S_s = ""
                                 For I = 7 To 12
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_bezug_vt(k)
                           Min_bez3v:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_bez3v
                                    End If

                                    S_s = S_s + S2 + "  "   '5 Byte
                                 Next I
                                 S_s = S_s + + Chr(13) + Chr(10)       '2 Byte
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Next J
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

               Case Fn4
                           Min_einsp4v:
                              W = Fs_speichdat_vt_t
                              S2 = Date(w)
                              S3 = Date(w)
                              If S2 <> S3 Then
                                 Goto Min_einsp4v
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              For J = 0 To 23
                           Min_einsp1v:
                                 S2 = Str(j)
                                 S3 = Str(j)
                                 If S2 <> S3 Then
                                    Goto Min_einsp1v
                                 End If
                                 S_s = S2 + ": "            ' 4 Byte
                                 For I = 1 To 6
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_einspeis_vt(k)
                           Min_einsp2v:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_einsp2v
                                    End If
                                    S_s = S_s + S2 + "  "   ' 5 Byte
                                 Next I
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)       '30 Byte
                                 S_s = ""
                                 For I = 7 To 12
                                    K = 12 * J
                                    K = K + I
                                    K3 = Fs_min_einspeis_vt(k)
                           Min_einsp3v:
                                    S2 = Str(k3)
                                    S3 = Str(k3)
                                    If S2 <> S3 Then
                                       Goto Min_einsp3v
                                    End If

                                    S_s = S_s + S2 + "  "   '5 Byte
                                 Next I
                                 S_s = S_s + + Chr(13) + Chr(10)       '2 Byte
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Next J
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

               Case Fn8                                     'Bezug aktuelle Leistung (1 min)
                     Fn8_lb:
                              L = Fs_bezug_l - Fs_bezug_l_alt1
                              L = L * 60
                              S2 = Str(l)
                              S3 = Str(l)
                              If S2 <> S3 Then
                                 Goto Fn8_lb
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

               Case Fn9                                     'Bezug Tagesenergie
                     Fn9_lb:
                              L = Fs_bezug_l - Fs_bezug_tagesstart
                              S2 = Str(l)
                              S3 = Str(l)
                              If S2 <> S3 Then
                                 Goto Fn9_lb
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

               Case Fn10                                    'Einspeis aktuelle Leistung (1 min)
                     Fn10_lb:
                              L = Fs_einspeis_l - Fs_einspeis_l_alt1
                              L = L * 60
                              S2 = Str(l)
                              S3 = Str(l)
                              If S2 <> S3 Then
                                 Goto Fn10_lb
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

              Case Fn11                                     'Einspeis aktuelle Leistung (1 min)
                     Fn11_lb:
                              L = Fs_einspeis_l - Fs_einspeis_tagesstart
                              S2 = Str(l)
                              S3 = Str(l)
                              If S2 <> S3 Then
                                 Goto Fn11_lb
                              End If

                              S_s = S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              Ack_pointer = 0
                              Javascript = 11
                              B = 1

             Case Fn12
             'Datum, Zeit, Solar akt. Leistung , Solar Tag, Solar Vortag, Bezug akt. Leistung , Bezug Tag, Bezug Vortag, Einspeisung akt. Leistung , Einspeisung Tag, Einspeisung Vortag, in W und Wh (1 min Wert)
                              'Datum, Zeit
                              S2 = Date(netio_time)
                              S3 = Time(netio_time)
                              S_s = S2 + ", " + S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              ' Solar akt. Leistung
                              Sing = Fs_akt_leist_min
                              Sing = Sing * 1000
                              Il = Sing
                              If Il < 50000 Then
                          Fn12_1b:
                                 S3 = Str(il)
                                 S4 = Str(il)
                                 If S3 <> S4 Then
                                    Goto Fn12_1b
                                 End If
                                 S_s = S3 + ", "
                              Else
                                 S_s = "0, "
                              End If
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              'Solar Tag, Solar Vortag,

                              Il = Fs_pulszahl - Fs_stundenstart(1)
                              Sing = Il
                              If Fs_pulsfaktor <> 1000 Then
                                 Sing = Sing * 1000
                                 Sing = Sing / Fs_pulsfaktor
                              End If
                              Il = Sing                     'Heute
                              Jl = Sysday(netio_time)
                              Jl = Jl - 1
                              Jl = Jl Mod 100
                              J = Jl
                              If J = 0 Then                 ' 5-8-12 Bug korrigiert (17)
                                  J = 30
                              End If

                              Jl = Fs_tageswerte(j) * 10    'Gestern
                         Fn12_1:
                              S3 = Str(il)
                              S4 = Str(il)
                              If S3 <> S4 Then
                                 Goto Fn12_1
                              End If
                              S_s = S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                         Fn12_2:
                              S3 = Str(jl)
                              S4 = Str(jl)
                              If S3 <> S4 Then
                                 Goto Fn12_2
                              End If
                              S_s = S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                             'Bezug akt. Leistung , Bezug Tag
                              L = Fs_bezug_l - Fs_bezug_l_alt1
                              L = L * 60

                              Flag = 0
                              If L > 500000 Then
                                Flag = 1
                              End If
                              If L < 0 Then
                                Flag = 1
                              End If
                         Fn12_3:
                              If Flag = 0 Then
                                S3 = Str(l)
                                S4 = Str(l)
                                If S3 <> S4 Then
                                  Goto Fn12_3
                                End If
                              Else
                                S3 = "0"
                              End If

                              S_s = S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              L = Fs_bezug_l - Fs_bezug_tagesstart
                              Flag = 0
                              If L > 500000 Then
                                Flag = 1
                              End If
                              If L < 0 Then
                                Flag = 1
                              End If

                         Fn12_4:
                              If Flag = 0 Then
                                S3 = Str(l)
                                S4 = Str(l)
                                If S3 <> S4 Then
                                  Goto Fn12_4
                                End If
                              Else
                                S3 = "0"
                              End If

                              S_s = S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              'Bezug Vortag
                              L = Fs_bezug_speichdat_t - 1  'zu druckender Tag in der Loop von 10 tagen

                              L2 = L Mod 30
                              I = L2                        'Speicherstelle fr Bezug und Einspeisung heute
                              If I = 0 Then                 ' 5-8-12 Bug korrigiert (17)
                                 I = 30
                              End If


                              L2 = L - 1
                              L2 = L2 Mod 30
                              M = L2                        'Speicherstelle Vortag fr Bezug und Einspeisung
                              If M = 0 Then                 ' 5-8-12 Bug korrigiert (18)
                                 M = 30
                              End If


                              ' Bezug
                              L = Fs_bezug_tagesstand(i)
                              L3 = Fs_bezug_tagesstand(m)
                              L = L - L3
                         Fn12_5:
                              Flag = 0
                              If L > 500000 Then
                                Flag = 1
                              End If
                              If L < 0 Then
                                Flag = 1
                              End If

                              If Flag = 0 Then
                                S3 = Str(l)
                                S4 = Str(l)
                                If S3 <> S4 Then
                                  Goto Fn12_5
                                End If
                              Else
                                S3 = "0"
                              End If
                              S_s = S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              'Einspeisung akt. Leistung , Einspeisung Tag, Einspeisung Vortag, in W und Wh (1 min Wert)
                              L = Fs_einspeis_l - Fs_einspeis_l_alt1
                              L = L * 60
                         Fn12_6:
                              Flag = 0
                              If L > 500000 Then
                                Flag = 1
                              End If
                              If L < 0 Then
                                Flag = 1
                              End If

                              If Flag = 0 Then
                                S3 = Str(l)
                                S4 = Str(l)
                                If S3 <> S4 Then
                                  Goto Fn12_6
                                End If
                              Else
                                S3 = "0"
                              End If

                              S_s = S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              L = Fs_einspeis_l - Fs_einspeis_tagesstart
                              Flag = 0
                              If L > 500000 Then
                                Flag = 1
                              End If
                              If L < 0 Then
                                Flag = 1
                              End If

                         Fn12_7:
                              If Flag = 0 Then
                                S3 = Str(l)
                                S4 = Str(l)
                                If S3 <> S4 Then
                                  Goto Fn12_7
                                End If
                              Else
                                S3 = "0"
                              End If

                              S_s = S3 + ", "
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              'Einspeis Vortag (i und m von oben)
                              L = Fs_einspeis_tagesstand(i)
                              L3 = Fs_einspeis_tagesstand(m)
                              L = L - L3
                         Fn12_8:
                              Flag = 0
                              If L > 500000 Then
                                Flag = 1
                              End If
                              If L < 0 Then
                                Flag = 1
                              End If

                              If Flag = 0 Then
                                 S3 = Str(l)
                                 S4 = Str(l)
                                 If S3 <> S4 Then
                                     Goto Fn12_8
                                 End If
                              Else
                                S3 = "0"
                              End If

                              S_s = S3 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

                              Ack_pointer = 0
                              Javascript = 11
                              B = 1



    '             Case "min_day.js" :
'                           If ntp_valid = 1 Then
'                              If Http_ack_pointer = 1 Then
'                                 K = 12 * Fs_min_i
'                                 K = K + Fs_min_j
'                                 Fs_tagertr_min = 0
'                                 For I = 1 To K
'                                    Fs_tagertr_min = Fs_tagertr_min + Fs_minw(i)
'                                 Next I
                                 Print "Debug: " ; Str(k) ; "  " ; Str(fs_tagertr_min)
'                                 S2 = Date$
'                                 S3 = Time$
'                                 If Fs_min_i < 2 Then
'                                    Loop1 = 0
'                                 Else
'                                    Loop1 = Fs_min_i - 1
'                                 End If
'     '                            Print "debug: " ; Fs_min_i ; "  " ; Loop1
'                                 For I = Fs_min_i To Loop1 Step -1       ' 16            ' Stunden
'                                    For J = 12 To 1 Step -1 ' 5 Min
'                                       Call Fs_js_string(i , J , Dataload_pointer)
'                                    Next J
'                                 Next I
'                                 Ack_pointer = 1            'Paket voll! auf zweites Paket umschalten
'                                 Javascript = 10
'                              Else
'                                 Loop2 = Ack_pointer * 2
'                                 Loop2 = Fs_min_i - Loop2
'      '                           Print "debug            3: " ; Fs_min_i ; "  " ; Loop2 ; "  " ; Ack_pointer
'                                 If Loop2 < 2 Then
'                                    Loop1 = 0
'                                    Ack_pointer = 0
'                                    Javascript = 11
'                                 Else
'                                    Loop1 = Loop2 - 1
'                                    Ack_pointer = Ack_pointer + 1
'                                    Javascript = 10
'                                 End If
'       '                          Print "debug2: " ; Fs_min_i ; "  " ; Loop1 ; "  " ; Loop2  ; "  " ;ack_pointer
'                                 For I = Loop2 To Loop1 Step -1       ' 16            ' Stunden
'                                    For J = 12 To 1 Step -1 ' 5 Min
'                                       Call Fs_js_string(i , J , Dataload_pointer)
'                                    Next J
'                                 Next I
'                               End If
'                           Else
'                               Fs_string = "No JS Data, NTP Time not yet valid" + Chr(13) + Chr(10)
'                               Dataload_pointer = Append_to_dataload(dataload_pointer , Fs_string)
'                               Ack_pointer = 0
'                               Javascript = 11
'                           End If
'                           B = 1



                #if Fs_debugvar = 3
                Case "debug.js" :
                              W = Fs_speicherdatum_tage
                              S2 = Date(w)
                              S_s = "Spdat_d: " + Str(fs_speicherdatum_tage) + " " + S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              W = Fs_speicherdatum_monate
                              S2 = Date(w)
                              S_s = "Spdat_m: " + Str(fs_speicherdatum_monate) + " " + S2 + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Fs_speicherdatum_tage = Ee_fs_speicherdatum_tage
                              Fs_speicherdatum_monate = Ee_fs_speicherdatum_monate
                              S_s = "ESpdat_d: " + Str(fs_speicherdatum_tage) + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = "ESpdat_m: " + Str(fs_speicherdatum_monate) + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              For K = 0 To 9
                                 L = Fs_speicherdatum_tage - K
                                 W = L
                                 S2 = Date(l)
                                 L2 = L Mod 100
                                 I = L2
                                 If I = 0 Then              ' 5-8-12 Bug korrigiert (17)
                                     I = 100
                                 End If

                                 L = Fs_tageswerte(i) * 10
                                 J = Ee_fs_tageswerte(i)
                                 L2 = J
                                 L2 = L2 * 10
                                 S_s = "TW-" + Str(k) + ": " + Str(l) + "  " + Str(l2) + " " + S2 + Chr(13) + Chr(10)
                                 Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Next K
                              S_s = "Tagesmax: " + Str(fs_tagesmax) + Chr(13) + Chr(10)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Ack_pointer = 0
                              Javascript = 11
                              B = 1
                  #endif
                 End Select

                 If B = 0 Then
                  If Ntp_valid = 1 Then
                   S_s = Http_stack_filename(stack_entry)
                   Print S_s
                   If Left(s_s , 4) = "estw" Then
                     I = Len(s_s)
                     I = I - 4
                     S_s = Right(s_s , I)
                     I = Len(s_s)
                     I = I - 3
                     S_s = Left(s_s , I)
                     If Len(s_s) = 6 Then
                        S2 = Left(s_s , 2)
                        I = Val(s2)
                        S3 = Right(s_s , 4)
                        J = Val(s3)
                        L = Sysday(netio_time)
                        L = L - I
                        W = L
                        S4 = Date(w)
                        L2 = L Mod 100
                        I = L2
                        If I = 0 Then                       ' 5-8-12 Bug korrigiert (18)
                           I = 100
                        End If
                        Fs_tageswerte(i) = J
                        Ee_fs_tageswerte(i) = Fs_tageswerte(i)
                     End If
                     S_s = "TWert: " + S2 + " " + S3 + " " + S4 + Chr(13) + Chr(10)
                   Elseif Left(s_s , 4) = "estd" Then
                     I = Len(s_s)
                     I = I - 4
                     S_s = Right(s_s , I)
                     I = Len(s_s)
                     I = I - 3
                     S_s = Left(s_s , I)
                     If Len(s_s) = 5 Then
                        L = Val(s_s)
                        Fs_speicherdatum_tage = L
                        Ee_fs_speicherdatum_tage = Fs_speicherdatum_tage
                        W = L
                        S4 = Date(w)
                        S_s = "SpDat T: " + S4 + Chr(13) + Chr(10)
                     Else
                        S_s = "Fehler" + Str(sysday(netio_time)) + Chr(13) + Chr(10)
                     End If
                   Elseif Left(s_s , 4) = "esma" Then
                     I = Len(s_s)
                     I = I - 4
                     S_s = Right(s_s , I)
                     I = Len(s_s)
                     I = I - 3
                     S_s = Left(s_s , I)
                     If Len(s_s) = 12 Then
                        S2 = Left(s_s , 5)
                        Fs_speicherdatum_monate = Val(s2)
                        Ee_fs_speicherdatum_monate = Fs_speicherdatum_monate
                        W = Fs_speicherdatum_monate
                        S4 = Date(w)
                        S3 = Right(s_s , 7)
                        Fs_monatswerte = Val(s3)
                        Ee_fs_monatswerte = Fs_monatswerte
                        S_s = "Vormonat: " + Str(fs_speicherdatum_monate) + " " + S4 + " " + Str(fs_monatswerte) + Chr(13) + Chr(10)
                     Else
                        S_s = "Fehler" + Str(sysday(netio_time)) + Chr(13) + Chr(10)
                     End If
                   Else
                     S_s = "Fehler. " + Str(sysday(netio_time)) + Chr(13) + Chr(10)
                   End If
                   Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                   Ack_pointer = 0
                   Javascript = 11
                   B = 1
                  End If
                 End If

                 If B = 0 Then
                     Print "Datei fehlt."
                     Ack_pointer = 0
                     Javascript = 11
                 End If
End Function

Sub Fs_js_string(byval I As Integer , Byval J As Integer , Byref Dataload_pointer As Word)
   Local S2 As String * 10
   Local S3 As String * 10
   Local K As Integer
   Local L As Long
   Local S4 As String * 5
   Local B As Byte                                          ' 1 wenn anzuzeigen
   Local M As Integer



      B = 0
      If Fs_min_i > I Then
         B = 1
      Elseif Fs_min_i = I Then
         If Fs_min_j >= J Then
            B = 1
         End If
      End If

     If B = 1 Then
         S2 = Date$
         S3 = Time$
         ' i sind 16            ' Stunden
         'j sind          ' 5 Min
         K = 12 * I
         K = K + J
         L = 4 + I
         S4 = Str(l)
         S4 = Format(s4 , "00")

         If J = 12 Then
            L = L + 1
            J = 0
            S4 = Str(l)
            S4 = Format(s4 , "00")
         End If

         S3 = S4 + ":"
         L = J * 5
         S4 = Str(l)
         S4 = Format(s4 , "00")
         S3 = S3 + S4 + ":00"
         M = Fs_minw(k) * 12
         '              6            1       8/9  1    8/9+1  1    4?        3            5                   5       1         1          1  Summe: 48
         Fs_string = "m[mi++]=" + Chr(34) + S2 + " " + S3 + "|" + Str(m) + ";0;" + Str(fs_tagertr_min) + ";0;0;" + Chr(34) + Chr(13) + Chr(10)
         Dataload_pointer = Append_to_dataload(dataload_pointer , Fs_string)
         Fs_tagertr_min = Fs_tagertr_min - Fs_minw(k)
 '        Print "Debug Sub: " ; Str(k) ; "  " ; Str(fs_tagertr_min) ; "  " ; Str(fs_minw(k))
      End If

End Sub

#endif

'-------------------------------------------------------------------------------
' AJAX
'  erzeugt dynamische Inhalte und legt diese im Dataload ab
'  FIN Flag wird sofort gesetzt!
'-------------------------------------------------------------------------------
#if Include_ajax = 1
Function Ajax(byval Stack_entry As Byte , Byref Dataload_pointer As Word) As Word
  Local S_s As String * 50
  Local Pindef As String * 1
  Local Portdef As String * 8
  Local Port As String * 2 , Pin As Byte , Onoff As Byte
  Local Temp_s As Single
    ' Dynamische Inhalte einfgen!
    ' statische Ajax Teile werden normal ber Senden ausgefhrt!

    ' Schaltfunktionen
      If Instr(http_stack_filename(stack_entry) , "sport") > 0 Then
         Pindef = Mid(http_stack_filename(stack_entry) , 7 , 1)
         Pin = Val(pindef)
         Port = Mid(http_stack_filename(stack_entry) , 6 , 1)
         Select Case Port
           Case "a" : Porta.pin = Not Porta.pin
           Case "b" : Portb.pin = Not Portb.pin
           Case "c" : Portdef = "2345678"
                      If Instr(portdef , Pindef ) > 0 Then
                         Portc.pin = Not Portc.pin
                      End If
           Case "d" : Portd.pin = Not Portd.pin
         End Select
         Http_stack_filename(stack_entry) = Mid(http_stack_filename(stack_entry) , 2 , 9)
      End If
      If Instr(http_stack_filename(stack_entry) , "port") > 0 Then
         Pindef = Mid(http_stack_filename(stack_entry) , 6 , 1)
         Pin = Val(pindef)
         Port = Mid(http_stack_filename(stack_entry) , 5 , 1)
         S_s = "<td align=center><b>" + Str(pin) + "</b></td>"
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         Select Case Port
           Case "a" : Onoff = Pina.pin
           Case "b" : Portdef = "2345678"
                      If Instr(portdef , Pindef) > 0 Then
                         Onoff = Pinb.pin
                      Else
                         Onoff = 2
                      End If
           Case "c" : Portdef = "2345678"
                      If Instr(portdef , Pindef) > 0 Then
                         Onoff = Pinc.pin
                      Else
                         Onoff = 2
                      End If
           Case "d" : Onoff = Pind.pin
         End Select
         If Onoff = 0 Then
            S_s = "<td align=center bgcolor=#ff5555>"
            Pindef = "0"
         Elseif Onoff = 1 Then
            S_s = "<td align=center bgcolor=#55ff55>"
            Pindef = "1"
         Else
            S_s = "<td align=center bgcolor=#000000>"
            Pindef = ""
         End If
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = "<b>" + Pindef + "</b></td>"
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         If Onoff < 2 Then
            S_s = "<td align=center><button onclick=" + Chr(34)
            Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
            S_s = "ajaxObj=new XMLHttp('sport" + Port + Str(pin) + ".ax2', 'port" + Port + Str(pin) + "');" + Chr(34)
            Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
            S_s = ">Switch</Button></td>"
         Else
            S_s = "<td align=center>Gesperrt!</td>"
         End If
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         Goto Ende
      End If


#if Include_temperatur = 1
      If Instr(http_stack_filename(stack_entry) , "retemp") > 0 Then
         Port = Mid(http_stack_filename(stack_entry) , 7 , 1)
         Pin = Val(port)
         Ee_temperatur_max(pin) = -550
         Temperatur_max(pin) = -550
         Ee_temperatur_min(pin) = 1250
         Temperatur_min(pin) = 1250
         Http_stack_filename(stack_entry) = Mid(http_stack_filename(stack_entry) , 3 , 9)
      End If

      If Instr(http_stack_filename(stack_entry) , "temp") > 0 Then
         Port = Mid(http_stack_filename(stack_entry) , 5 , 1)
         Pin = Val(port)
         If Status_temp(pin) = 0 Then
           S_s = "<td align=center><b>" + Str(pin) + "</b></td><td align=right>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Temp_s = Temperatur(pin) / 10
           S_s = Fusing(temp_s , "##.#")
           S_s = S_s + " &deg;C</td><td align=right>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Temp_s = Temperatur_min(pin) / 10
           S_s = Fusing(temp_s , "##.#")
           S_s = S_s + " &deg;C</td><td align=right>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Temp_s = Temperatur_max(pin) / 10
           S_s = Fusing(temp_s , "##.#")
           S_s = S_s + " &deg;C</td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<td>Ok</td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<td>"
           Select Case Sensor_temp(pin)
             Case 1 : S_s = S_s + "DS18B20"
             Case 2 : S_s = S_s + "DS1820"
             Case Else : S_s = S_s + "unbekannt"
           End Select
           S_s = S_s + "</td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           ' Button reset min max
           S_s = "<td><button onclick=" + Chr(34)
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "ajaxObj=new XMLHttp('retemp" + Str(pin) + ".ax2', 'temp" + Str(pin) + "');" + Chr(34)
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = ">RST</Button></td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           ' Button refresh diese eine Zeile!
           S_s = "<td><button onclick=" + Chr(34)
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "ajaxObj=new XMLHttp('temp" + Str(pin) + ".ax2', 'temp" + Str(pin) + "');" + Chr(34)
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = ">Refresh</Button></td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         Else
           S_s = "<td align=center><b>" + Str(pin) + "</b></td><td></td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<td></td><td></td><td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Select Case Status_temp(pin)
             Case 1 : S_s = "CRC Error!"
             Case 2 : S_s = "Kein Sensor"
             Case Else :
                       S_s = "Fehler Nr.: " + Str(status_temp(pin))
             End Select
             S_s = S_s + "</td><td></td><td></td><td></td>"
             Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         End If
         Goto Ende
       End If
#endif
         Select Case Http_stack_filename(stack_entry)
                Case "clicks.ax" :
                              S_s = "Seitenaufrufe: " + Str(http_z_index)
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
#if Include_sdcard > 0
                Case "picdat.ax" :
                           Call Activate_sdcard
                           Files = Dir( "net-io.jpg")
                           S_s = Filedate()
                           S_s = S_s + " - "
                           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s )
                           S_s = Filetime()
                           S_s = S_s + " - "
                           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s )
                           S_s = Str(filelen())
                           S_s = S_s + " Byte"
                           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s )
                           Call Activate_enc28j60
                Case "sdcard.ax":
                           Call Activate_sdcard
                           Files = Dir( "*.*")
                           While Len(files) > 0             ' if there was a file found
                              S_s = "<tr><td>" + Files + "</td>"
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = Filedate()
                              S_s = "<td>" + S_s + "</td>"
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = Filetime()
                              S_s = "<td>" + S_s + "</td>"
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              S_s = Str(filelen())
                              S_s = "<td>" + S_s + "</td></tr>"
                              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
                              Files = Dir()
                           Wend
                           Call Activate_enc28j60
#endif
                Case Else
                             Print "Fehler! Datei nicht gefunden: " ; Http_stack_filename(stack_entry)
         End Select
Ende:
    Ajax = Dataload_pointer
End Function
#endif


'-------------------------------------------------------------------------------
' GET_HEADER
'  erzeugt den Header zu Anfragen und legt diese im Dataload ab
'-------------------------------------------------------------------------------
Function Get_header(byval Stack_entry As Byte , Byref Dataload_pointer As Word) As Word
 Local S_s As String * 42
         S_s = "HTTP/1.0 "
         If Http_stack_type(stack_entry) <> 0 Then
            S_s = S_s + "200 OK" + Cr_lf
         Else
            S_s = S_s + "404 Not Found" + Cr_lf
         End If
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = "Server: " + My_s12_hostname + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         S_s = "Content-Type: "
         Select Case Http_stack_type(stack_entry)
            Case 1 : S_s = S_s + "text/html"
            Case 2 : S_s = S_s + "image/jpeg"
            Case 3 : S_s = S_s + "image/x-icon"
#if Include_javascript = 1
            Case 4 : S_s = S_s + "application/x-javascript"
#endif
            Case 5 : S_s = S_s + "image/gif"
            Case 6 : S_s = S_s + "image/png"
            Case 7 : S_s = S_s + "text/css"
            Case Else :
                     Http_stack_fin(stack_entry) = 1
                     Set Tcp_fin
                     S_s = S_s + "text/html"
         End Select
         S_s = S_s + Cr_lf + Cr_lf
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         Get_header = Dataload_pointer
End Function

'-------------------------------------------------------------------------------
' Ip_to_string
'  Reversed Long Wert einer IP zu String wandeln
'-------------------------------------------------------------------------------
Function Ip_to_string(byval Ip As Long) String
   Ip = Reversed_long(ip)
   Ip_to_string = Ip2str(ip)
End Function



'-------------------------------------------------------------------------------
' Append_to_dataload
'    hngt String Fragmente an den Ausgabepuffer an
'    und gibt den aktuallisierten Pointer von Buffer zurck
'-------------------------------------------------------------------------------
Function Append_to_dataload(byref Dataload_pointer As Word , Byref S_s As String ) As Word
   Local W_w As Word
   W_w = Len(s_s)
   If W_w > 0 Then
     W_w = Memcopy(s_s , Tcp_dataload(dataload_pointer) , W_w)
     Dataload_pointer = Dataload_pointer + W_w
   End If
   Append_to_dataload = Dataload_pointer
End Function



'-------------------------------------------------------------------------------
' Rotate_fifo
' schieben, bis max Anzahl erreicht oder Fifo(1) <> 0
'-------------------------------------------------------------------------------
Sub Rotate_fifo
Local Zeiger As Byte
   Http_stack_flag = 0
   For Zeiger = 1 To Http_max_ports
      Fifo_tmp(zeiger) = 0
      If Fifo(zeiger) > 0 Then
         Incr Http_stack_flag
         Fifo_tmp(http_stack_flag) = Fifo(zeiger)
      End If
   Next
   For Zeiger = 1 To Http_max_ports
         Fifo(zeiger) = Fifo_tmp(zeiger)
   Next
'(
   If Fifo(1) = 0 Then
     For Zeiger_h = 2 To Http_max_ports
        Zeiger_l = Zeiger_h - 1
        Fifo(zeiger_l) = Fifo(zeiger_h)
     Next
     Fifo(http_max_ports) = 0
   End If
')
End Sub

'-------------------------------------------------------------------------------
' Http_stack_life
'   HTTP Stack bereinigen, wenn Lifetime abgelaufen
'-------------------------------------------------------------------------------
'#if Netio_mode <> 1
Sub Http_stack_life
   Local Dead As Byte
   Local Lb As Byte


'(
   For Lb = 1 To Http_max_ports
       If Http_stack_lifetime(lb) > 1 Then
          Decr Http_stack_lifetime(lb)
       End If

       If Http_stack_lifetime(lb) = 1 Then
           Http_stack_lifetime(lb) = 0
           Call Reset_stack_entry(lb)
       End If
   Next
')


   Dead = 0
   For Lb = 1 To Http_max_ports
       If Http_stack_lifetime(lb) > 1 Then
          Decr Http_stack_lifetime(lb)
       End If
       If Http_stack_lifetime(lb) = 1 Then
         ' Check if FIN Flag set and ACK on last Segent!
         ' otherwise RESEND SEGMENT!
         ' RESET TCP_RST! , wenn fin flag noch nicht gesetzt!!
         If Http_stack_fin(lb) < 2 Then
             Http_stack_lifetime(lb) = Http_lifetime_seconds
         '    Http_stack_fin(lb) = 0
             Dead = Proccess_fifo_stack_entry(lb)
             Incr Http_stack_retry(lb)
             If Http_stack_retry(lb) > 2 Then
               Call Http_reset(lb)
               #if Debug_http > 2
               Print "Anschieben ohne Erfolg!"
               #endif
             Else
               #if Debug_http > 2
               Print "Anschieben (" ; Str(http_stack_retry(lb)) ; ")"
               #endif
             End If
         Else
            Call Reset_stack_entry(lb)
            'Http_stack_lifetime(lb) = 0
            #if Debug_http > 2
                Call Http_dump_stack( "***  STACK LIFETIME OVER ***" , Lb )
            #endif
         End If
       End If
   Next

End Sub
'#endif

'-------------------------------------------------------------------------------
'  Http_reset
'    wenn Lifetime abgelaufen und Stackeintrag nicht komplett versendet wurde,
'    senden wir ein tcp_rst, um der Gegenseite eine unvollstndige
'    bermittlung mitzuteilen!
'-------------------------------------------------------------------------------
Sub Http_reset(byref Lb As Byte)

       #if Debug_http > 2
         Print "<-- HTTP RESET! (" ; Lb ; ")"
       #endif
         Call Tcp_ip_header(lb)
         Tcp_flags = 0
         Set Tcp_ack
         Set Tcp_rst
         Tcp_seqnum = Http_stack_acknum(lb)
         Tcp_acknum = Http_stack_seqnum(lb)
         Ip_b_time_to_live = 128
         Call Set_ip_header_len(&H3e)
         Tcp_hdr = &H70
         Call Ip_header_checksum
         Call Tcp_checksum
         Call Enc28j60packetsend(62)
         Call Reset_stack_entry(lb)
End Sub


'-------------------------------------------------------------------------------
' HTTP_READ_FILE_FROM_SDCARD
'  liest die Daten der Files von der SD-CARD
'   Rckgabe 0  -> keine SD Card
'   Rckgabe 1  -> File nicht vorhanden
'   Rckgabe 2  -> Kein Filename bergeben!
'   Rckgabe 3  -> Pointer nach Fileende!
'   Rckgabe 10 -> noch Daten zu lesen!
'   Rckgabe 11 -> keine Daten mehr zu lesen!
'-------------------------------------------------------------------------------
#if Netio_mode <> 1 And Include_sdcard = 1
Function Http_read_file_from_sdcard(byref Datei As String , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word ) As Byte
   Local Max_transmission_sd As Word
   Local Http_file_size As Long
   Local Payload_len As Long

      If Sd_card_ok = 1 Then
        If Len(datei) > 0 Then
           'noch was zu lesen?
           Call Activate_sdcard
           Open Datei For Binary As #4
           Http_file_size = Lof(#4)
           If Http_file_size > 0 Then
              If Http_ack_pointer < Http_file_size Then
                 ' was ist noch abzuarbeiten?
                 Payload_len = Http_file_size - Http_ack_pointer
                 ' hinter Header positionieren!
                 Payload_len = Payload_len - Dataload_pointer
                 ' was passt noch in das Segment rein?
                 Max_transmission_sd = Maxload - Dataload_pointer
                 ' ist das, was noch von dem File versendet werden muss grer,
                 ' als das, was noch in das Segment passt?
                 If Payload_len > Max_transmission_sd Then
                       ' Rckgabe 10 -> noch Daten zu lesen!
                       Http_read_file_from_sdcard = 10
                 Else
                       ' Rckgabe 11 -> keine Daten mehr zu lesen!
                       Http_read_file_from_sdcard = 11
                       Max_transmission_sd = Payload_len
                       Incr Max_transmission_sd
                 End If
                 #if Debug_http > 3
                    Print "Open File For Read: " ; Datei ; " (" ; Http_file_size ; " Byte)"
                    Print "Quelle Startbyte  : " ; Http_ack_pointer
                    Print "Ziel   Startbyte  : " ; Dataload_pointer
                    Print "Anzahl Bytes      : " ; Max_transmission_sd
                 #endif
                 Get #4 , Tcp_dataload(dataload_pointer) , Http_ack_pointer , Max_transmission_sd
' Incr Dataload_pointer
               Else
                ' Rckgabe 3 -> Pointer nach Fileende!
                 Http_read_file_from_sdcard = 3
               End If
           Else
            ' Rckgabe 1 -> File nicht vorhanden (Filesize = 0)
              Http_read_file_from_sdcard = 1
           End If
           Close #4
        Else
         ' Rckgabe 2 -> Kein Filename bergeben! (Len(datei) > 0)
         Http_read_file_from_sdcard = 2
        End If
        Call Activate_enc28j60
        Dataload_pointer = Dataload_pointer + Max_transmission_sd
     Else
      ' Rckgabe 0 -> keine SD Card
      Http_read_file_from_sdcard = 0
     End If                                                 'Sd_card_ok = 1
End Function
#endif

'-------------------------------------------------------------------------------
' HTTP_READ_FILE_FROM_FLASH
'  liest die Daten der Files aus dem Flash
'    Rckgabewert = gelesene Bytes
'-------------------------------------------------------------------------------
#if Netio_mode = 1 Or Netio_mode = 90
Function Http_m32_content(byref Datei As String , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
Local S_s As String * 70
Local S_d As String * 10
Local S_e As String * 10
Local W1 As Word , B As Byte , C As Byte , D As Byte , E As Byte
Local Sing As Single
Local I As Integer
Local J As Integer
Local K As Integer
Local Il As Long
Local Jl As Long
Local Kl As Long
Local S3 As String * 10
Local S4 As String * 10

      Fn1 = Fs_ev_url + "_i.htm"


      If Datei = "index.htm" Or Datei = Fn1 Then
         If Http_ack_pointer = 1 Then
           'Dataload_pointer = Append_to_dataload(dataload_pointer , "<!DOCTYPE html>")
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<html><Head>")
           'Dataload_pointer = Append_to_dataload(dataload_pointer , "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>")
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<title>FreeSol Datenlogger</title></head><body>")
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<center><table width=600 border=1>")
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<tr><td><center><h2>")
           Dataload_pointer = Append_to_dataload(dataload_pointer , "FreeSol Datenlogger</h2></center></td></tr>")
           S_s = "<tr><td>Anlagenname: " + My_s12_hostname + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
            S_s = "<tr><td>Version: " + Fs_version + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
      Index1:
           S3 = Str(http_z_index)
           S4 = Str(http_z_index)
           If S3 <> S4 Then
              Goto Index1
           End If
           S_s = "<tr><td>Seitenaufrufe: " + S3 + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_d = Date(netio_time)
           S_e = Time(netio_time)
           S_s = "<tr><td>NTP Time: " + S_d + ", " + S_e + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<tr><td>Startzeit, Zeit bis NTP Synchronisierung: "
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = Fs_startzeit_ntp + ", " + Fs_startzeit_offset + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Il = Fs_pulszahl - Fs_stundenstart(1)
           Sing = Il
           If Fs_pulsfaktor <> 1000 Then
              Sing = Sing * 1000
              Sing = Sing / Fs_pulsfaktor
           End If
           Il = Sing                                        'Heute
           Jl = Sysday(netio_time)
           Jl = Jl - 1
           Jl = Jl Mod 100
           J = Jl
           If J = 0 Then                                    ' 5-8-12 Bug korrigiert (19)
              J = 100
           End If

           Jl = Fs_tageswerte(j) * 10
           Kl = Sysday(netio_time)
           Kl = Kl - 2
           Kl = Kl Mod 100
           K = Kl
           If K = 0 Then                                    ' 5-8-12 Bug korrigiert (20)
              K = 100
           End If

           Kl = Fs_tageswerte(k) * 10
           S_s = "<tr><td>Tageswerte heute, gestern, vorgestern: "
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
      Index7:
           S3 = Str(il)
           S4 = Str(il)
           If S3 <> S4 Then
              Goto Index7
           End If
           S_s = S3 + ", "
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
      Index8:
           S3 = Str(jl)
           S4 = Str(jl)
           If S3 <> S4 Then
              Goto Index8
           End If
           S_s = S3 + ", "
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
      Index9:
           S3 = Str(kl)
           S4 = Str(kl)
           If S3 <> S4 Then
              Goto Index9
           End If
           S_s = S3 + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Il = Fs_pulszahl + Fs_pulszahlges
           If Fs_pulsfaktor <> 1000 Then
              Sing = Il
              Sing = Sing * 1000
              Sing = Sing / Fs_pulsfaktor
              Il = Sing
           End If
      Index6:
           S3 = Str(il)
           S4 = Str(il)
           If S3 <> S4 Then
              Goto Index6
           End If
           S_s = "<tr><td>S0-Zhlerstand: " + S3 + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Il = Fs_pulszahl + Fs_pulszahlges
           Sing = Il / Fs_pulsfaktor
           S_d = Fusing(sing , "#######.#")
           S_s = "<tr><td>kWh gesamt: " + S_d + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Sing = Fs_pulszahl - Fs_stundenstart(1)
           Sing = Sing / Fs_anlagenleistung
           If Fs_pulsfaktor <> 1000 Then
              Sing = Sing * 1000
              Sing = Sing / Fs_pulsfaktor
           End If
           S_d = Fusing(sing , "###.##")
           S_s = "<tr><td>kWh/kWp heute: " + S_d + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_d = Fusing(fs_akt_leist , "##.###")
           S_s = "<tr><td>Aktuelle Leistung in kW: " + S_d + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

           If Datei = Fn1 Then
              Ack_pointer = 2
              Http_m32_content = 10
           Else
              Ack_pointer = 4
           End If
           Http_m32_content = 10

         Elseif Ack_pointer = 2 Then
           S3 = Fusing(fs_bezug , "##.###")
           S4 = Fusing(fs_einspeis , "##.###")
           S_s = "<tr><td>SML Bezug/Einspeisung in kWh: " + S3 + "; " + S4 + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<tr><td>SML Lesezeitpunkt: " + Fs_smllesezeit + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

           Ack_pointer = 3
           Http_m32_content = 10
         Elseif Ack_pointer = 3 Then
           S_s = "<tr><td>Meldung: " + Fs_meldung + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = Hex(fs_crcstore)
           S_s = S_s + " " + Hex(fs_crccalc)
           S_s = "<tr><td>Prfsumme (gelesen/berechnet): " + S_s + "</td></tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

           Ack_pointer = 4
           Http_m32_content = 10
         Elseif Ack_pointer = 4 Then
           S_s = "<tr><td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           If Datei = Fn1 Then
              S_s = "<button onclick='document.location=" + Chr(34) + Fn1 + Chr(34) + ";'>Reload</button>"
           Else
              S_s = "<button onclick='document.location=" + Chr(34) + "index.htm" + Chr(34) + ";'>Reload</button>"
           End If
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<button onclick='document.location=" + Chr(34) + "graph1.svg" + Chr(34) + ";'>Tagesgrafik</button>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<button onclick='document.location=" + Chr(34) + "months.js" + Chr(34) + ";'>Monate</button>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<button onclick='document.location=" + Chr(34) + "days_hist.js" + Chr(34) + ";'>Tage</button>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<button onclick='document.location=" + Chr(34) + "minutes.js" + Chr(34) + ";'>5 Minuten</button>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "<button onclick='document.location=" + Chr(34) + "base_vars.js" + Chr(34)
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = ";'>Konfiguration</button>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Ack_pointer = 5
           Http_m32_content = 10
         Elseif Ack_pointer = 5 Then
            S_s = "</td></tr><tr><td>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "</table></center>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<center><table width=1000 border=1>")
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<tr>")
           S_s = "<th colspan='24'>Stundenwerte in Zhlerpulsen: </th>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "</tr><tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           For I = 0 To 9
      Index2:
              S3 = Str(i)
              S4 = Str(i)
              If S3 <> S4 Then
                 Goto Index2
              End If
              S_s = "<th>0" + S3 + "</th>"
              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next I
           Ack_pointer = 6
           Http_m32_content = 10
         Elseif Ack_pointer = 6 Then
           For I = 10 To 23
      Index3:
              S3 = Str(i)
              S4 = Str(i)
              If S3 <> S4 Then
                 Goto Index3
              End If
              S_s = "<th>" + S3 + "</th>"
              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next I
           S_s = "</tr><tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           For I = 1 To 24
      Index4:
              S3 = Str(fs_stundenstart(i))
              S4 = Str(fs_stundenstart(i))
              If S3 <> S4 Then
                 Goto Index4
              End If
              S_s = "<td>" + S3 + "</td>"
              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next I
           S_s = "</tr>"
           S_s = "</tr><tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           For I = 1 To 24
      Index5:
              S3 = Str(fs_stundenwerte(i))
              S4 = Str(fs_stundenwerte(i))
              If S3 <> S4 Then
                 Goto Index5
              End If
              S_s = "<td>" + S3 + "</td>"
              Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Next I
           S_s = "</tr>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_s = "</table></center></body></html>"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Http_m32_content = 11
         End If

      Elseif Datei = "iframe_1.htm" Then
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<html><head><title>Time</title></head><body>")

           S_d = Date(netio_time)
           S_e = Time(netio_time)
           S_s = S_d + ", " + S_e
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

           Dataload_pointer = Append_to_dataload(dataload_pointer , "</body></html>")
           Http_m32_content = 11

      Elseif Datei = "iframe_2.htm" Then
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<html><head><title>Current power</title></head><body>" )

           S_d = Fusing(fs_akt_leist , "##.###")
           S_s = S_d + " kW"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

           Dataload_pointer = Append_to_dataload(dataload_pointer , "</body></html>")
           Http_m32_content = 11

      Elseif Datei = "iframe_3.htm" Then
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<html><head><title>Total yield</title></head><body>")

           Il = Fs_pulszahl + Fs_pulszahlges
           Sing = Il / Fs_pulsfaktor
           S_d = Fusing(sing , "#######.#")
           S_s = S_d + " kWh"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

           Dataload_pointer = Append_to_dataload(dataload_pointer , "</body></html>")
           Http_m32_content = 11

      Elseif Datei = "iframe_4.htm" Then
           Dataload_pointer = Append_to_dataload(dataload_pointer , "<html><head><title>Todays result</title></head><body>")

           Il = Fs_pulszahl - Fs_stundenstart(1)
           Sing = Il
           If Fs_pulsfaktor <> 1000 Then
              Sing = Sing * 1000
              Sing = Sing / Fs_pulsfaktor
           End If
           Il = Sing                                        'Heute

      Index_if1:
           S3 = Str(il)
           S4 = Str(il)
           If S3 <> S4 Then
              Goto Index_if1
           End If
           S_s = S3 + " Wh"

           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)

           Dataload_pointer = Append_to_dataload(dataload_pointer , "</body></html>")
           Http_m32_content = 11
      Elseif Datei = "iframe_5.htm" Then
           S_d = Date(netio_time)
           S_e = Time(netio_time)
           S_s = S_d + ", " + S_e + ", "
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           S_d = Fusing(fs_akt_leist_min , "##.###")
           S_s = S_d + " kW"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Http_m32_content = 11
      Elseif Datei = "iframe_6.htm" Then
      Index_if6:
           S3 = Str(fs_crcfehlerzahl)
           S4 = Str(fs_crcfehlerzahl)
           If S3 <> S4 Then
              Goto Index_if6
           End If
            S_s = S3
       Index_if6b:
           S3 = Str(fs_smllesezahl)
           S4 = Str(fs_smllesezahl)
           If S3 <> S4 Then
              Goto Index_if6b
           End If

           S_s = S_s + "  " + S3 + " (SML Lesefehlerzahl , Lesezahl gesamt)"
           Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
           Http_m32_content = 11
      Else
         S_s = "</head><body><H1>Not Found </H1></body></html>"
         Dataload_pointer = Append_to_dataload(dataload_pointer , "<html><head><title>404</title>")
         Dataload_pointer = Append_to_dataload(dataload_pointer , S_s)
         Http_m32_content = 11
      End If
End Function
#endif


'-------------------------------------------------------------------------------
' HTTP_READ_FILE_FROM_FLASH
'  liest die Daten der Files aus dem Flash
'    Rckgabewert = gelesene Bytes
'-------------------------------------------------------------------------------
#if Netio_mode <> 1 And Include_sdcard = 0 And Netio_mode <> 90
Function Http_read_file_from_flash(byref Datei As String , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
   Local Max_transmission As Long
   Local Zeiger As Word
   Local Size As Word
   Local Payload_len As Long
   Dim Position_file As Word

   Dim Tempy As Word
      If Datei = "index.htm" Then
        Restore Mainpage
        Position_file = Loadlabel(mainpage)
      Elseif Datei = "favicon.ico" Then
        Restore Favicon
        Position_file = Loadlabel(favicon)
      Else
         Restore 404
         Position_file = Loadlabel(404)
      End If

      Read Size

      ' die Daten wurden mit $inc SIZE!!! eingebunden.
      ' Dadurch steht in den ersten zwei Byte die Filegre!!!
      Incr Position_file
      Incr Position_file

      Http_read_file_from_flash = 0
      'Fileende erreicht? (...noch was zu lesen?)
      If Http_ack_pointer < Size Then

                 'wieviele Bytes noch zu senden
                 Payload_len = Size - Http_ack_pointer
                 'wenn Header mit eingebunden, Platz davon abziehen
                 'Payload_len = Payload_len - Dataload_pointer

                 'max. Platz in Buffer berechnen
                 'Header wurde geladen!
                 If Dataload_pointer > 0 Then
                   Max_transmission = Maxload - Dataload_pointer
                 Else
                   Max_transmission = Maxload
                 End If

                 If Payload_len > Max_transmission Then
                       ' Rckgabe 10 -> noch Daten zu lesen!
                       Http_read_file_from_flash = 10
                 Else
                       ' Rckgabe 11 -> keine Daten mehr zu lesen!
                       Http_read_file_from_flash = 11
                       Max_transmission = Payload_len
                       'Incr Max_transmission
                 End If
         Position_file = Position_file + Http_ack_pointer
         Decr Position_file
        ' nach MagicWhiteSmoke in ASM ausgefhrt /six1 12.7.09
        ' Readpointer setzen
        $asm
           LDS R8,{Position_file}
           LDS R9,{Position_file  + 1}
        $end Asm
'        Decr Max_transmission                               ' 0 basiert!
       '  #if Debug_http > 3
            Print "Sende " ; Datei ; " von " ; Http_ack_pointer ; ", " ; Max_transmission ; " Byte  (Dataload_pointer: " ; Dataload_pointer ; ")"
        ' #endif
        For Zeiger = 0 To Max_transmission
            ' Byte lesen auf das der Readpointer zeigt, nach Tempy speichern
            $asm
              MOVW ZL, R8
              LPM R0, Z+
              STS {tempy}, R0
              MOVW R8, ZL
            $end Asm
            Tcp_dataload(zeiger) = Tempy
        Next
 '       Incr Max_transmission
    End If
    Incr Max_transmission
    Dataload_pointer = Max_transmission
'    Dataload_pointer = Dataload_pointer + Frame_size
End Function
#endif

'-------------------------------------------------------------------------------
' Tcp_ip_header
'  erstellt aus der HTTP-Position (tempx) den TCP/IP Header in "BUFFER"
'-------------------------------------------------------------------------------
Sub Tcp_ip_header(byval Tempx As Byte)
      ' *** ETH Header ***
          Eth_b_dest_mac(1) = Http_stack_mac0(tempx)
          Eth_b_dest_mac(2) = Http_stack_mac1(tempx)
          Eth_b_dest_mac(3) = Http_stack_mac2(tempx)
          Eth_b_dest_mac(4) = Http_stack_mac3(tempx)
          Eth_b_dest_mac(5) = Http_stack_mac4(tempx)
          Eth_b_dest_mac(6) = Http_stack_mac5(tempx)
          Eth_b_src_mac(1) = My_b_macaddr(1)
          Eth_b_src_mac(2) = My_b_macaddr(2)
          Eth_b_src_mac(3) = My_b_macaddr(3)
          Eth_b_src_mac(4) = My_b_macaddr(4)
          Eth_b_src_mac(5) = My_b_macaddr(5)
          Eth_b_src_mac(6) = My_b_macaddr(6)

          Eth_w_packettype = Eth_w_packettype_ip

      ' *** IP Header ***
          ' 14     Version=4 (obere 4 Bit)
          '        Headerlen:4-Bit (unter 4-Bit) Wert * 32 Bit = Bytes... Bsp.: 5 * 32Bit = 160Bit / 8 = 20 Byte
          Ip_b_vers_and_length = Ip_standard_vers_and_length
          ' 15     IHL=0 differntiated Service Field
          Ip_b_type_of_service = 0
          ' 16-17  Length IP-Header, TCP-Header and Payload
          Ip_w_packet_length = Http_stack_headerlength(tempx)
          ' 18-19  Identification, will be incr by 1! fragmented Segmentes!!!
          Ip_w_identifier = Http_stack_fragment(tempx)
          ' 20-21  always 0x40 0x00
          Ip_w_fragmentation = Reversed_word(&H4000)
          ' 22    Time to live (128)
          Ip_b_time_to_live = Http_stack_lifetime(tempx)
          ' 23    TCP Protokoll 0x06
          Ip_b_protocol = Ip_protocol_tcp
          ' 24-25 IP-Header Checksum
          '*** will be generated later on send
          ' 26-29 IP Source Address
          T_ip_destaddr = Http_stack_ipsrc(tempx)
          ' 30-33 IP Destination Address
          T_ip_srcaddr = Http_stack_ipdest(tempx)

      ' *** TCP Header ***
          ' 34-35 Source Port
          Tcp_srcport = Http_stack_port_dest(tempx)
          ' 36-37 Destination Port
          Tcp_destport = Http_stack_port_src(tempx)
          ' 38-41 Sequnce number
'          Tcp_seqnum = Http_stack_seqnum(tempx)
          Tcp_seqnum = Http_stack_acknum(tempx)
          ' 42-45 Acknowledge number
'          Tcp_acknum = Http_stack_acknum(tempx)
          Tcp_acknum = Http_stack_seqnum(tempx)
          ' 46    Header Length  should be always 20 Byte!
          ' (obere 4 Bit) Wert * 32 Bit = Bytes... Bsp.: 5 * 32Bit = 160Bit / 8 = 20 Byte
          Tcp_hdr = &H50
          ' 47    TCP Flags
          Tcp_flags = 0
          ' 48-49 Window Size
          Tcp_win_size = &HFFFF                             'Reversed_word(maxload)
          ' 50-51 TCP Checksum
          '*** will be generated later on send
          ' 52-53 0x0000

         ' Laut RFC 791 muss die TTL von Paketen auf jedem Router,
         ' den das Paket auf dem Weg vom Sender zum Ziel passiert,
         ' um mindestens 1 verringert werden.
         ' IP-Pakete mit einer aktuellen TTL von 0 werden vom Router verworfen.
         Ip_b_time_to_live = 128
End Sub

'-------------------------------------------------------------------------------
' Dump_tcp_ip
'  erstellt einen Hexdump Bytes 0-53 von Buffer
'-------------------------------------------------------------------------------
#if Debug_http > 2
Sub Dump_tcp_ip
   Local B_b1 As Byte , B_b2 As Byte , B_b3 As Byte

   Print "----- 54 Byte Header Dump -----"
   For B_b1 = 1 To 4
     Print B_b1 ; " - ";
     For B_b2 = 1 To 16
        B_b3 = B_b1 - 1
        B_b3 = B_b3 * 16
        B_b3 = B_b3 + B_b2
        If B_b3 <= 54 Then
           Print Hex(buffer(b_b3)) ; " ";
           If B_b2 = 8 Then
             Print " ";
           End If
        End If
     Next
     Print
   Next
   Print
End Sub
#endif

'-------------------------------------------------------------------------------
' Paket_senden
'  wenn fifo(1) Inhalt hat, senden...
'-------------------------------------------------------------------------------
Sub Paket_senden
   Local Dummy_l As Long
   Local Tempx As Byte , Pos As Byte
   Local Http_transmission_ready As Byte
   Local Http_transmission_byte As Word
   Local Http_ack_pointer As Long
   Local Temp_w As Word
   Local Dataload_pointer As Word

     Call Rotate_fifo
     If Fifo(1) > 0 Then
       Tempx = Fifo(1)
       Fifo(1) = 0
       If Http_stack_filename(tempx) <> "" Then
          ' RELOAD TCP/IP Header
          ' Wir wissen nicht, was vorher in "Buffer" los war!
          ' Also den gesamten IP und TCP Header neu formieren!
          Call Tcp_ip_header(tempx)

          ' only for debuging! cost's a lot of time :-)
          '  Call Dump_tcp_ip
          '  Call Dump_eth_header
          '  Call Dump_ip_header

          '============================================================
          '= Berechnung Nutzlast:                                     =
          '============================================================
          '= ETH-II Mac (Src + Dst) 2 x 6 Byte = 12 Byte              =
          '= IP Type                              2 Byte  (IP 0x8000) =
          '= IP Protokoll                        20 Byte              =
          '= TCP Header                          20 Byte              =
          '=                                     -------              =
          '= Nutzlast ->  Max_framelen (1506) -  54 Byte = 1452       =
          '============================================================
          '=  ACHTUNG! ENC28J60 auf Huge Frame umgeschaltet!          =
          '=  MACON3.HFRMEN=1 ansonsten muckt der ENC schon bei 1500! =
          '============================================================
          Http_ack_pointer = Reversed_long(http_stack_acknum(tempx))
          Http_ack_pointer = Http_ack_pointer - Http_stack_headerlength(tempx)

          Dataload_pointer = 0
          If Http_ack_pointer = 1 And Http_stack_type(tempx) <> 8 And Http_stack_type(tempx) <> 9 And Http_stack_type(tempx) <> 10 Then
#if Netio_mode = 1
             If Commandmodem32 = 0 Then
#endif
                Dataload_pointer = Get_header(tempx , Dataload_pointer)
                Http_stack_headerlength(tempx) = Dataload_pointer
#if Netio_mode = 1
             End If
#endif
             #if Debug_http > 3
                Print "NEW HEADERLENGTH!: " ; Http_stack_headerlength(tempx)
             #endif
          End If

          #if Debug_http > 1
              Print "<-- Send: (Stack: " ; Tempx ; " / FIFO: 1) " ; Http_stack_filename(tempx) ; " (Pointer " ; Http_ack_pointer ; ") Typ: " ; Http_stack_type(tempx)
          #endif

          Http_transmission_ready = 0
          If Http_stack_type(tempx) = 4 Then
'*** JAVASCRIPT CONTENT ***
            #if Include_javascript = 1
              Http_transmission_ready = Javascript(tempx , Http_ack_pointer , Dataload_pointer)
            #endif
            #if Include_ajax = 1
'*** AJAX CONTENT ***
          Elseif Http_stack_type(tempx) = 8 Then
             ' AJAX Request
             ' Dynamische AJAX Inhalte werden, um Pakete zu sparen, gleich mit gesendet!
             Dataload_pointer = Ajax(tempx , Dataload_pointer)
             #if Debug_http > 1
                Print "<-- AJAX Request " ; Http_stack_filename(tempx) ; " Port: " ; Http_stack_port_dest(tempx)
             #endif
             Http_transmission_ready = 11
           #endif
          #if Include_svg = 1
'*** SVG Content ***
          Elseif Http_stack_type(tempx) = 10 Then
             Http_transmission_ready = Svg(tempx , Http_ack_pointer , Dataload_pointer)
          #endif
          Else
            #if Netio_mode = 1 Or Netio_mode = 90
              Http_transmission_ready = Http_m32_content(http_stack_filename(tempx) , Http_ack_pointer , Dataload_pointer )
            #else

              #if Include_sdcard = 0
                 '*** READ FROM FLASH ***
                  Http_transmission_ready = Http_read_file_from_flash(http_stack_filename(tempx) , Http_ack_pointer , Dataload_pointer )
              #else
                 '*** READ FROM SD-CRAD ***
                 '   Rckgabe 0  -> keine SD Card
                 '   Rckgabe 1  -> File nicht vorhanden
                 '   Rckgabe 2  -> Kein Filename bergeben!
                 '   Rckgabe 3  -> Pointer nach Fileende!
                 '   Rckgabe 10 -> noch Daten zu lesen!
                 '   Rckgabe 11 -> keine Daten mehr zu lesen!
                Http_transmission_ready = Http_read_file_from_sdcard(http_stack_filename(tempx) , Http_ack_pointer , Dataload_pointer )
                #if Debug_http > 3
                   Select Case Http_transmission_ready
                     #if Debug_http > 3
                     Case 0 : Print "<-> keine SD Card"
                     Case 1 : Print "<-> File nicht vorhanden"
                     Case 2 : Print "<-> Kein Filename bergeben"
                     Case 3 : Print "<-> Pointer nach Fileende"
                     #endif
                     #if Debug_http > 1
                     Case 10 : Print "<-> noch Daten zu lesen"
                     Case 11 : Print "<-> keine Daten mehr zu lesen"
                     #endif
                   End Select
                #endif
                If Http_transmission_ready < 10 Then
                   ' Reload Header! 404 ... File not found
                   Http_stack_type(tempx) = 0
                   Dataload_pointer = 0
                   Dataload_pointer = Get_header(tempx , Dataload_pointer)
                   Http_stack_headerlength(tempx) = Dataload_pointer
                   Http_ack_pointer = Reversed_long(http_stack_acknum(tempx))
                   Http_ack_pointer = Http_ack_pointer - Http_stack_headerlength(tempx)
                   Http_stack_filename(tempx) = "404.htm"
                   Http_transmission_ready = Http_read_file_from_sdcard(http_stack_filename(tempx) , Http_ack_pointer , Dataload_pointer )
                   Http_transmission_ready = 11
                End If
              #endif                                        'Include_sdcard
            #endif                                          'Netio_mode
         End If

         Tcp_flags = 0
         Set Tcp_ack
         Set Tcp_psh
        ' Set Tcp_urg                                       'Vorrangpaket, weil Segment zur bertragung der Datei gehrt!

         If Http_transmission_ready = 11 Then
          ' bertragung beendet!
            Set Tcp_fin
            Http_stack_fin(tempx) = 1
            #if Debug_http > 2
               Print "<<< STACK FIN=1"
            #endif
         End If
         Http_stack_lifetime(tempx) = Http_lifetime_seconds

         Dataload_pointer = Dataload_pointer + Frame_size
         Tcp_hdr = &H50
         Call Set_ip_header_len(dataload_pointer)
         Call Ip_header_checksum
         Call Tcp_checksum
         Call Enc28j60packetsend(dataload_pointer)          'send it
      Else
         'kill kill kill :-)
         #if Debug_http > 1
            Print ">>>FATAL ERROR! No Filename " ; Http_stack_filename(tempx)
         #endif
         'Call Reset_stack_entry(tempx)
      End If                                                ' If Http_stack_filename(tempx) <> "" Then
  End If                                                    ' If Fifo(1) > 0 Then
End Sub

'-------------------------------------------------------------------------------
' SET IP HEADER LENGTH
'-------------------------------------------------------------------------------
Sub Set_ip_header_len(byref Headerlen As Word)
     Headerlen = Headerlen - 14                             'Ethernet Buffer abziehen
     T_ip_pktlen0 = High(headerlen)
     T_ip_pktlen1 = Low(headerlen)
End Sub


'-------------------------------------------------------------------------------
' Dump HTTP-STACK
'-------------------------------------------------------------------------------
#if Debug_http > 2
Sub Http_dump_stack(byval Art As String , Byval Entry As Byte)
Local Li As Integer
Local Dummy_l As Long
Local Dummy_s As String * 15
Local Dummy_s2 As String * 5
Local Len_b As Byte
   Print
   Print Art
   Print " Pos FIFO  IP              Port  Datei          FIN"
   For Li = 1 To Http_max_ports
       If Entry = Li Then
         Print "* ";
       Else
         Print "  ";
       End If

       ' lfdnr
       Dummy_s = Str(li)
       Len_b = 4 - Len(dummy_s)
       Print Dummy_s ; Space(len_b) ;

       ' fifo
       Print Fifo(li) ; "    ";

       ' ip
       Dummy_l = Reversed_long(http_stack_ipsrc(li))
       Dummy_s = Ip2str(dummy_l)
       Len_b = 16 - Len(dummy_s)
       Print Dummy_s ; Space(len_b) ;

       ' port
       Dummy_s = Str(reversed_word(http_stack_port_src(li)))
       Len_b = 6 - Len(dummy_s)
       Print Dummy_s ; Space(len_b) ;

       ' Filename
       Dummy_s = Http_stack_filename(li)
       Len_b = 15 - Len(dummy_s)
       Print Dummy_s ; Space(len_b) ;

       ' FIN Flag
       Print Http_stack_fin(li)
   Next Li
End Sub
#endif

'-------------------------------------------------------------------------------
' Dump HTTP-FLAG
'-------------------------------------------------------------------------------
#if Debug_http > 3
Sub Http_debug_flags
     Print
     Print "-----------------"
     Print "- Incoming http -"
     Print "-----------------"
     Print "  FIN " ; Tcp_fin
     Print "  SYN " ; Tcp_syn
     Print "  RST " ; Tcp_rst
     Print "  PSH " ; Tcp_psh
     Print "  ACK " ; Tcp_ack
     Print "  URG " ; Tcp_urg
     Print
End Sub
#endif